/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.subset.views;

import net.imglib2.Cursor;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.ops.operation.subset.views.IterableSubsetViewCursor;
import net.imglib2.ops.operation.subset.views.SubsetViews;
import net.imglib2.type.Type;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.view.IterableRandomAccessibleInterval;
import net.imglib2.view.Views;

public class IterableSubsetView<T extends Type<T>>
extends IterableRandomAccessibleInterval<T> {
    private boolean isOptimizable;
    private int planeOffset;
    private int numPlaneDims;
    private RandomAccessibleInterval<T> src;

    public IterableSubsetView(RandomAccessibleInterval<T> src, Interval interval) {
        super(SubsetViews.subsetView(src, interval));
        this.src = src;
        this.isOptimizable = false;
        this.planeOffset = 1;
        if (!SubsetViews.intervalEquals(this, interval)) {
            if (src instanceof IterableSubsetView) {
                src = ((IterableSubsetView)src).src;
            }
            if (src instanceof IterableInterval && ((IterableInterval)((Object)src)).iterationOrder() instanceof FlatIterationOrder) {
                this.isOptimizable = true;
                for (int d = 0; d < interval.numDimensions(); ++d) {
                    if (interval.dimension(d) <= 1L) continue;
                    if (interval.dimension(d) != src.dimension(d)) {
                        this.isOptimizable = false;
                        break;
                    }
                    ++this.numPlaneDims;
                    if (this.numPlaneDims == d + 1) continue;
                    this.isOptimizable = false;
                    break;
                }
                if (this.isOptimizable) {
                    long[] iterDims = new long[src.numDimensions() - this.numPlaneDims];
                    long[] cubePos = (long[])iterDims.clone();
                    for (int d = this.numPlaneDims; d < src.numDimensions(); ++d) {
                        iterDims[d - this.numPlaneDims] = src.dimension(d);
                        cubePos[d - this.numPlaneDims] = interval.min(d);
                    }
                    this.planeOffset = iterDims.length == 0 ? 0 : (int)(IntervalIndexer.positionToIndex(cubePos, iterDims) * super.size());
                }
            }
        }
    }

    @Override
    public Cursor<T> cursor() {
        if (this.isOptimizable) {
            return new IterableSubsetViewCursor<T>(Views.iterable(this.src).cursor(), (int)super.size(), this.planeOffset, this.numPlaneDims);
        }
        return Views.iterable((RandomAccessibleInterval)this.sourceInterval).cursor();
    }

    @Override
    public Cursor<T> localizingCursor() {
        if (this.isOptimizable) {
            return new IterableSubsetViewCursor<T>(Views.iterable(this.src).localizingCursor(), (int)super.size(), this.planeOffset, this.numPlaneDims);
        }
        return Views.iterable((RandomAccessibleInterval)this.sourceInterval).cursor();
    }
}

