/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.real.unary;

import net.imglib2.ops.operation.real.unary.RealUnaryOperation;
import net.imglib2.type.numeric.RealType;

public final class RealConvert<I extends RealType<I>, O extends RealType<O>>
implements RealUnaryOperation<I, O> {
    private double scale;
    private double inputMin;
    private double inputMax;
    private double outputMin;
    private double outputMax;

    public RealConvert(double inputMin, double inputMax, double outputMin, double outputMax) {
        this.inputMin = inputMin;
        this.inputMax = inputMax;
        this.outputMin = outputMin;
        this.outputMax = outputMax;
        this.scale = (outputMax - outputMin) / (inputMax - inputMin);
    }

    @Override
    public O compute(I x, O output) {
        double value = (x.getRealDouble() - this.inputMin) * this.scale + this.outputMin;
        output.setReal(value);
        return output;
    }

    @Override
    public RealConvert<I, O> copy() {
        return new RealConvert<I, O>(this.inputMin, this.inputMax, this.outputMin, this.outputMax);
    }
}

