/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.real.unary;

import java.util.Random;
import net.imglib2.ops.operation.real.unary.RealUnaryOperation;
import net.imglib2.type.numeric.RealType;

public final class RealAddNoise<I extends RealType<I>, O extends RealType<O>>
implements RealUnaryOperation<I, O> {
    private final double rangeMin;
    private final double rangeMax;
    private final double rangeStdDev;
    private final Random rng;

    public RealAddNoise(double min, double max, double stdDev) {
        this.rangeMin = min;
        this.rangeMax = max;
        this.rangeStdDev = stdDev;
        this.rng = new Random();
        this.rng.setSeed(System.currentTimeMillis());
    }

    @Override
    public O compute(I x, O output) {
        int i = 0;
        do {
            double newVal;
            if (!(this.rangeMin <= (newVal = x.getRealDouble() + this.rng.nextGaussian() * this.rangeStdDev)) || !(newVal <= this.rangeMax)) continue;
            output.setReal(newVal);
            return output;
        } while (i++ <= 100);
        throw new IllegalArgumentException("noise function failing to terminate. probably misconfigured.");
    }

    @Override
    public RealAddNoise<I, O> copy() {
        return new RealAddNoise<I, O>(this.rangeMin, this.rangeMax, this.rangeStdDev);
    }
}

