/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.real.unary;

import net.imglib2.converter.Converter;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.type.numeric.RealType;

public class Normalize<T extends RealType<T>>
implements UnaryOperation<T, T>,
Converter<T, T> {
    private final double m_newMin;
    private final double m_factor;
    private final double m_oldMin;

    public Normalize(T oldMin, T oldMax, T newMin, T newMax) {
        this(oldMin.getRealDouble(), oldMax.getRealDouble(), newMin.getRealDouble(), newMax.getRealDouble());
    }

    protected Normalize(double factor, double oldMin, double newMin) {
        this.m_oldMin = oldMin;
        this.m_newMin = newMin;
        this.m_factor = factor;
    }

    public Normalize(double oldMin, double oldMax, double newMin, double newMax) {
        this(Normalize.normalizationFactor(oldMin, oldMax, newMin, newMax), oldMin, newMin);
    }

    @Override
    public T compute(T input, T output) {
        output.setReal((input.getRealDouble() - this.m_oldMin) * this.m_factor + this.m_newMin);
        return output;
    }

    @Override
    public UnaryOperation<T, T> copy() {
        return new Normalize<T>(this.m_factor, this.m_oldMin, this.m_newMin);
    }

    @Override
    public void convert(T input, T output) {
        this.compute(input, output);
    }

    public static synchronized double normalizationFactor(double oldMin, double oldMax, double newMin, double newMax) {
        return 1.0 / (oldMax - oldMin) * (newMax - newMin);
    }
}

