/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.real.unary;

import net.imglib2.converter.Converter;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.type.numeric.RealType;

public final class Convert<I extends RealType<I>, O extends RealType<O>>
implements UnaryOperation<I, O>,
Converter<I, O> {
    private final TypeConversionTypes m_mode;
    private double m_inMin;
    private final double m_outMax;
    private double m_outMin;
    private double m_factor;
    private final I m_inType;
    private final O m_outType;
    private final UnaryOperation<I, O> m_op;

    public Convert(I inType, O outType, TypeConversionTypes mode) {
        this.m_outType = outType;
        this.m_mode = mode;
        this.m_op = this.initOp();
        this.m_inType = inType;
        this.m_inMin = inType.getMinValue();
        this.m_outMax = this.m_outType.getMaxValue();
        this.m_outMin = this.m_outType.getMinValue();
        this.m_factor = mode == TypeConversionTypes.SCALE || mode == TypeConversionTypes.DIRECTCLIP ? (inType.getMaxValue() - this.m_inMin) / (outType.getMaxValue() - this.m_outMin) : 1.0;
    }

    public void setOutMin(double outMin) {
        this.m_outMin = outMin;
    }

    public void setInMin(double inMin) {
        this.m_inMin = inMin;
    }

    public double getFactor() {
        return this.m_factor;
    }

    public void setFactor(double newFactor) {
        this.m_factor = newFactor;
    }

    private UnaryOperation<I, O> initOp() {
        switch (this.m_mode) {
            case DIRECTCLIP: {
                return new UnaryOperation<I, O>(){
                    private double v;

                    @Override
                    public O compute(I op, O r) {
                        this.v = op.getRealDouble();
                        if (this.v > Convert.this.m_outMax) {
                            r.setReal(Convert.this.m_outMax);
                        } else if (this.v < Convert.this.m_outMin) {
                            r.setReal(Convert.this.m_outMin);
                        } else {
                            r.setReal(this.v);
                        }
                        return r;
                    }

                    @Override
                    public UnaryOperation<I, O> copy() {
                        return this;
                    }
                };
            }
            case DIRECT: {
                return new UnaryOperation<I, O>(){

                    @Override
                    public O compute(I op, O r) {
                        r.setReal(op.getRealDouble());
                        return r;
                    }

                    @Override
                    public UnaryOperation<I, O> copy() {
                        return this;
                    }
                };
            }
            case SCALE: {
                return new UnaryOperation<I, O>(){

                    @Override
                    public O compute(I op, O r) {
                        r.setReal((op.getRealDouble() - Convert.this.m_inMin) / Convert.this.m_factor + Convert.this.m_outMin);
                        return r;
                    }

                    @Override
                    public UnaryOperation<I, O> copy() {
                        return this;
                    }
                };
            }
            case SCALECLIP: {
                return new UnaryOperation<I, O>(){
                    private double v;

                    @Override
                    public O compute(I op, O r) {
                        this.v = (op.getRealDouble() - Convert.this.m_inMin) / Convert.this.m_factor + Convert.this.m_outMin;
                        if (this.v > Convert.this.m_outMax) {
                            r.setReal(Convert.this.m_outMax);
                        } else if (this.v < Convert.this.m_outMin) {
                            r.setReal(Convert.this.m_outMin);
                        } else {
                            r.setReal(this.v);
                        }
                        return r;
                    }

                    @Override
                    public UnaryOperation<I, O> copy() {
                        return this;
                    }
                };
            }
        }
        return null;
    }

    @Override
    public final O compute(I op, O r) {
        return (O)((RealType)this.m_op.compute(op, r));
    }

    @Override
    public UnaryOperation<I, O> copy() {
        return new Convert<I, O>(this.m_inType, this.m_outType, this.m_mode);
    }

    @Override
    public void convert(I input, O output) {
        this.m_op.compute(input, output);
    }

    public static enum TypeConversionTypes {
        DIRECTCLIP,
        SCALE,
        DIRECT,
        SCALECLIP;

    }
}

