/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.randomaccessibleinterval.unary.regiongrowing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.labeling.Labeling;
import net.imglib2.labeling.LabelingType;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.ops.operation.randomaccessibleinterval.unary.regiongrowing.AbstractRegionGrowing;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;

public class VoronoiLikeRegionGrowing<L extends Comparable<L>, T extends Type<T> & Comparable<T>>
extends AbstractRegionGrowing<LabelingType<L>, L, Labeling<L>, Labeling<L>> {
    private Cursor<LabelingType<L>> m_seedLabCur;
    private final RandomAccess<T> m_srcImgRA;
    private final T m_threshold;
    protected Img<T> m_srcImg;
    protected final boolean m_fillHoles;

    public VoronoiLikeRegionGrowing(Img<T> srcImg, T threshold, boolean fillHoles) {
        super(AbstractRegionGrowing.get8ConStructuringElement(srcImg.numDimensions()), AbstractRegionGrowing.GrowingMode.SYNCHRONOUS, false);
        this.m_threshold = threshold;
        this.m_fillHoles = fillHoles;
        this.m_srcImgRA = srcImg.randomAccess();
        this.m_srcImg = srcImg;
    }

    @Override
    public Labeling<L> compute(Labeling<L> in, Labeling<L> out) {
        super.compute(in, out);
        if (this.m_fillHoles) {
            this.reLabelBackgroundInsideCells(out);
        }
        return out;
    }

    @Override
    protected void initRegionGrowing(Labeling<L> srcImg) {
        this.m_seedLabCur = srcImg.localizingCursor();
    }

    @Override
    protected L nextSeedPosition(int[] seedPos) {
        while (this.m_seedLabCur.hasNext()) {
            this.m_seedLabCur.fwd();
            if (((LabelingType)this.m_seedLabCur.get()).getLabeling().isEmpty()) continue;
            this.m_seedLabCur.localize(seedPos);
            return (L)((Comparable)((LabelingType)this.m_seedLabCur.get()).getLabeling().get(0));
        }
        return null;
    }

    @Override
    protected boolean includeInRegion(int[] oldPos, int[] nextPos, L label) {
        this.m_srcImgRA.setPosition(nextPos);
        return ((Comparable)((Object)((Type)this.m_srcImgRA.get()))).compareTo(this.m_threshold) >= 0;
    }

    @Override
    protected void queueProcessed() {
    }

    private void reLabelBackgroundInsideCells(Labeling<L> resLab) {
        Img<BitType> visited = null;
        try {
            visited = new ArrayImgFactory().imgFactory(new BitType()).create(resLab, new BitType());
        }
        catch (IncompatibleTypeException e) {
            e.printStackTrace();
        }
        Cursor labCur = resLab.localizingCursor();
        Cursor visitedCur = visited.cursor();
        RandomAccess<BitType> visitedRA = visited.randomAccess();
        int[] pos = new int[resLab.numDimensions()];
        while (labCur.hasNext()) {
            labCur.fwd();
            visitedCur.fwd();
            labCur.localize(pos);
            if (((BitType)visitedCur.get()).get() || !((LabelingType)labCur.get()).getLabeling().isEmpty()) continue;
            this.bfsBackGround(resLab, pos, visitedRA);
        }
    }

    private void bfsBackGround(Labeling<L> resLab, int[] startPos, RandomAccess<BitType> visitedRA) {
        LinkedList<Object> queue = new LinkedList<Object>();
        ArrayList<int[]> visitedNow = new ArrayList<int[]>();
        queue.add(startPos);
        visitedRA.setPosition(startPos);
        ((BitType)visitedRA.get()).set(true);
        List labelNeighbour = ((LabelingType)resLab.firstElement()).getMapping().emptyList();
        boolean ok = true;
        RandomAccess resLabRA = resLab.randomAccess();
        int[] perm = new int[resLab.numDimensions()];
        while (!queue.isEmpty()) {
            int[] pos = (int[])queue.remove();
            visitedNow.add(pos);
            Arrays.fill(perm, -1);
            int i = resLab.numDimensions() - 1;
            block1: while (i > -1) {
                int j;
                int[] nextPos = (int[])pos.clone();
                boolean add = true;
                for (j = 0; j < resLab.numDimensions(); ++j) {
                    int n = j;
                    nextPos[n] = nextPos[n] + perm[j];
                    if (nextPos[j] >= 0 && (long)nextPos[j] < resLab.dimension(j)) continue;
                    add = false;
                    break;
                }
                if (add) {
                    visitedRA.setPosition(nextPos);
                    resLabRA.setPosition(nextPos);
                    if (!((BitType)visitedRA.get()).get() && ((LabelingType)resLabRA.get()).getLabeling().isEmpty()) {
                        ((BitType)visitedRA.get()).set(true);
                        queue.add(nextPos.clone());
                    } else if (!((BitType)visitedRA.get()).get() && !((LabelingType)resLabRA.get()).getLabeling().isEmpty()) {
                        if (labelNeighbour.isEmpty()) {
                            labelNeighbour = ((LabelingType)resLabRA.get()).getLabeling();
                        } else if (labelNeighbour != ((LabelingType)resLabRA.get()).getLabeling()) {
                            ok = false;
                        }
                    }
                }
                for (i = perm.length - 1; i > -1; --i) {
                    if (perm[i] >= 1) continue;
                    int n = i;
                    perm[n] = perm[n] + 1;
                    for (j = i + 1; j < perm.length; ++j) {
                        perm[j] = -1;
                    }
                    continue block1;
                }
            }
        }
        if (ok && !labelNeighbour.isEmpty()) {
            for (int i = 0; i < visitedNow.size(); ++i) {
                resLabRA.setPosition((int[])visitedNow.get(i));
                ((LabelingType)resLabRA.get()).setLabeling(labelNeighbour);
            }
        }
    }

    @Override
    public UnaryOperation<Labeling<L>, Labeling<L>> copy() {
        return new VoronoiLikeRegionGrowing<L, T>(this.m_srcImg, this.m_threshold.copy(), this.m_fillHoles);
    }
}

