/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.randomaccessibleinterval.unary.regiongrowing;

import java.util.Collection;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.labeling.Labeling;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.ops.operation.randomaccessibleinterval.unary.regiongrowing.VoronoiLikeRegionGrowing;
import net.imglib2.type.Type;

public class VoronoiLikeLocalRegionGrowing<L extends Comparable<L>, T extends Type<T> & Comparable<T>>
extends VoronoiLikeRegionGrowing<L, T> {
    private Img<T> m_srcImg;
    private RandomAccess<T> m_srcImgRA;

    public VoronoiLikeLocalRegionGrowing(Img<T> srcImg, boolean fillHoles) {
        super(srcImg, ((Type)srcImg.firstElement()).createVariable(), fillHoles);
        this.m_srcImg = srcImg;
        this.m_srcImgRA = this.m_srcImg.randomAccess();
    }

    @Override
    protected void initRegionGrowing(Labeling<L> srcLab) {
        super.initRegionGrowing(srcLab);
        Collection<L> labels = srcLab.getLabels();
        for (Comparable label : labels) {
            Cursor<T> cur = srcLab.getIterableRegionOfInterest(label).getIterableIntervalOverROI(this.m_srcImg).localizingCursor();
            while (cur.hasNext()) {
                cur.fwd();
            }
        }
    }

    @Override
    protected boolean includeInRegion(int[] oldPos, int[] nextPos, L label) {
        this.m_srcImgRA.setPosition(nextPos);
        return false;
    }

    @Override
    public UnaryOperation<Labeling<L>, Labeling<L>> copy() {
        return new VoronoiLikeLocalRegionGrowing<L, T>(this.m_srcImg, this.m_fillHoles);
    }
}

