/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.randomaccessibleinterval.unary.regiongrowing;

import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.labeling.LabelingType;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.ops.operation.randomaccessibleinterval.unary.regiongrowing.AbstractRegionGrowing;
import net.imglib2.type.NativeType;

public class CCA<T extends NativeType<T> & Comparable<T>, I extends RandomAccessibleInterval<T> & IterableInterval<T>, LL extends RandomAccessibleInterval<LabelingType<Integer>> & IterableInterval<LabelingType<Integer>>>
extends AbstractRegionGrowing<T, Integer, I, LL> {
    private Cursor<T> srcCur;
    private RandomAccess<T> srcRA;
    private Integer m_labelNumber;
    private final T m_background;
    private T m_currentLabel;
    private ThreadSafeLabelNumbers m_synchronizer;

    public CCA(long[][] structuringElement, T background) {
        this(structuringElement, background, null);
    }

    public CCA(long[][] structuringElement, T background, ThreadSafeLabelNumbers synchronizer) {
        super(structuringElement, AbstractRegionGrowing.GrowingMode.ASYNCHRONOUS, false);
        this.m_synchronizer = synchronizer == null ? new ThreadSafeLabelNumbers() : synchronizer;
        this.m_background = background;
        this.m_labelNumber = this.m_synchronizer.aquireNewLabelNumber();
    }

    @Override
    protected void initRegionGrowing(I srcImg) {
        this.srcCur = ((IterableInterval)srcImg).localizingCursor();
        this.srcRA = srcImg.randomAccess();
    }

    @Override
    protected Integer nextSeedPosition(int[] seedPos) {
        while (this.srcCur.hasNext()) {
            this.srcCur.fwd();
            if (((Comparable)((Object)((NativeType)this.srcCur.get()))).compareTo(this.m_background) == 0) continue;
            this.srcCur.localize(seedPos);
            this.m_currentLabel = (NativeType)((NativeType)this.srcCur.get()).copy();
            return this.m_labelNumber;
        }
        return null;
    }

    protected synchronized Integer labelNumber() {
        return this.m_labelNumber;
    }

    @Override
    protected boolean includeInRegion(int[] oldPos, int[] nextPos, Integer label) {
        this.srcRA.setPosition(nextPos);
        return ((Comparable)((Object)((NativeType)this.srcRA.get()))).compareTo(this.m_currentLabel) == 0;
    }

    @Override
    protected synchronized void queueProcessed() {
        this.m_labelNumber = this.m_synchronizer.aquireNewLabelNumber();
    }

    @Override
    public UnaryOperation<I, LL> copy() {
        return new CCA<NativeType, I, LL>((long[][])this.m_structuringElement.clone(), (NativeType)this.m_background.copy(), this.m_synchronizer);
    }

    private class ThreadSafeLabelNumbers {
        private int m_labelNumber = 1;

        protected ThreadSafeLabelNumbers() {
        }

        protected final synchronized int aquireNewLabelNumber() {
            return this.m_labelNumber++;
        }
    }
}

