/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.randomaccessibleinterval.unary.regiongrowing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.labeling.LabelingType;
import net.imglib2.labeling.NativeImgLabeling;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.util.Pair;

public abstract class AbstractRegionGrowing<T extends Type<T>, L extends Comparable<L>, I extends IterableInterval<T> & RandomAccessibleInterval<T>, LL extends RandomAccessibleInterval<LabelingType<L>> & IterableInterval<LabelingType<L>>>
implements UnaryOperation<I, LL> {
    private final GrowingMode m_mode;
    private final Map<L, List<L>> m_labelMap;
    private final boolean m_allowOverlap;
    private RandomAccess<BitType> m_visitedRA = null;
    private RandomAccess<LabelingType<L>> m_visitedLabRA = null;
    protected final long[][] m_structuringElement;

    public AbstractRegionGrowing(long[][] structuringElement, GrowingMode mode, boolean allowOverlap) {
        this.m_structuringElement = structuringElement;
        this.m_mode = mode;
        this.m_allowOverlap = allowOverlap;
        this.m_labelMap = new HashMap<L, List<L>>();
    }

    private long[] resultDims(Interval src) {
        long[] dims = new long[src.numDimensions()];
        src.dimensions(dims);
        return dims;
    }

    @Override
    public LL compute(I op, LL r) {
        this.initRegionGrowing(op);
        LinkedList<Pair<int[], L>> q = new LinkedList<Pair<int[], L>>();
        if (this.m_allowOverlap) {
            NativeImgLabeling tmp = new NativeImgLabeling(new ArrayImgFactory().create(this.resultDims((Interval)op), new IntType()));
            this.m_visitedLabRA = tmp.randomAccess();
        } else {
            BitType bt = new BitType();
            Img<BitType> tmp = null;
            try {
                tmp = new ArrayImgFactory().imgFactory(bt).create((Dimensions)op, bt);
            }
            catch (IncompatibleTypeException e) {
                // empty catch block
            }
            this.m_visitedRA = tmp.randomAccess();
        }
        RandomAccess<LabelingType<L>> resRA = r.randomAccess();
        int[] pos = new int[op.numDimensions()];
        while (true) {
            L label;
            if ((label = this.nextSeedPosition(pos)) != null) {
                this.setVisitedPosition(pos);
                if (this.isMarkedAsVisited(label)) continue;
                this.markAsVisited(label);
                q.addLast(new Pair<Object, L>(pos.clone(), label));
                resRA.setPosition(pos);
                this.setLabel(resRA, label);
                if (this.m_mode != GrowingMode.ASYNCHRONOUS) continue;
                this.growProcess(q, resRA, op);
                continue;
            }
            if (this.m_mode == GrowingMode.SYNCHRONOUS) {
                this.growProcess(q, resRA, op);
            }
            if (!this.hasMoreSeedingPoints()) break;
        }
        return r;
    }

    private synchronized void growProcess(LinkedList<Pair<int[], L>> q, RandomAccess<LabelingType<L>> resLabRA, I src) {
        while (!q.isEmpty()) {
            Pair<int[], L> p = q.removeFirst();
            int[] pos = (int[])p.a;
            Comparable label = (Comparable)p.b;
            for (long[] offset : this.m_structuringElement) {
                boolean outOfBounds = false;
                int[] nextPos = (int[])pos.clone();
                for (int i = 0; i < pos.length; ++i) {
                    nextPos[i] = pos[i] + (int)offset[i];
                    if (nextPos[i] >= 0 && (long)nextPos[i] < src.dimension(i)) continue;
                    outOfBounds = true;
                    break;
                }
                if (outOfBounds) continue;
                this.updatePosition(resLabRA, q, pos, nextPos, label);
            }
        }
        this.queueProcessed();
    }

    private void updatePosition(RandomAccess<LabelingType<L>> resLabRA, LinkedList<Pair<int[], L>> queue, int[] pos, int[] nextPos, L label) {
        this.setVisitedPosition(nextPos);
        if (this.isMarkedAsVisited(label)) {
            return;
        }
        if (!this.includeInRegion(pos, nextPos, label)) {
            return;
        }
        this.markAsVisited(label);
        queue.addLast(new Pair<int[], L>(nextPos, label));
        resLabRA.setPosition(nextPos);
        this.setLabel(resLabRA, label);
    }

    protected void setLabel(RandomAccess<LabelingType<L>> ra, L label) {
        List<Object> labeling;
        if (((LabelingType)ra.get()).getLabeling().isEmpty()) {
            labeling = this.m_labelMap.get(label);
            if (labeling == null) {
                labeling = new ArrayList<L>(1);
                labeling.add(label);
                labeling = ((LabelingType)ra.get()).getMapping().intern(labeling);
            }
        } else {
            labeling = new ArrayList(((LabelingType)ra.get()).getLabeling());
            labeling.add(label);
        }
        ((LabelingType)ra.get()).setLabeling(labeling);
    }

    private void setVisitedPosition(int[] pos) {
        if (this.m_allowOverlap) {
            this.m_visitedLabRA.setPosition(pos);
        } else {
            this.m_visitedRA.setPosition(pos);
        }
    }

    private boolean isMarkedAsVisited(L label) {
        if (this.m_allowOverlap) {
            return ((LabelingType)this.m_visitedLabRA.get()).getLabeling().contains(label);
        }
        return ((BitType)this.m_visitedRA.get()).get();
    }

    private void markAsVisited(L label) {
        if (this.m_allowOverlap) {
            ArrayList l = new ArrayList(((LabelingType)this.m_visitedLabRA.get()).getLabeling());
            l.add(label);
            ((LabelingType)this.m_visitedLabRA.get()).setLabeling(l);
        } else {
            ((BitType)this.m_visitedRA.get()).set(true);
        }
    }

    protected abstract void initRegionGrowing(I var1);

    protected abstract L nextSeedPosition(int[] var1);

    protected abstract boolean includeInRegion(int[] var1, int[] var2, L var3);

    protected abstract void queueProcessed();

    protected boolean hasMoreSeedingPoints() {
        return false;
    }

    public static long[][] get8ConStructuringElement(int dimensions) {
        int nElements = 1;
        for (int i = 0; i < dimensions; ++i) {
            nElements *= 3;
        }
        long[][] result = new long[--nElements][dimensions];
        long[] position = new long[dimensions];
        Arrays.fill(position, -1L);
        block1: for (int i = 0; i < nElements; ++i) {
            System.arraycopy(position, 0, result[i], 0, dimensions);
            if (i == nElements / 2 - 1) {
                position[0] = position[0] + 2L;
                continue;
            }
            for (int j = 0; j < dimensions; ++j) {
                if (position[j] != 1L) {
                    int n = j;
                    position[n] = position[n] + 1L;
                    continue block1;
                }
                position[j] = -1L;
            }
        }
        return result;
    }

    public static long[][] get4ConStructuringElement(int dimensions) {
        int nElements = dimensions * 2;
        long[][] result = new long[nElements][dimensions];
        for (int d = 0; d < dimensions; ++d) {
            result[d * 2] = new long[dimensions];
            result[d * 2 + 1] = new long[dimensions];
            result[d * 2][d] = -1L;
            result[d * 2 + 1][d] = 1L;
        }
        return result;
    }

    public static enum GrowingMode {
        SYNCHRONOUS,
        ASYNCHRONOUS;

    }
}

