/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.randomaccessibleinterval.unary.morph;

import java.util.ArrayList;
import net.imglib2.IterableInterval;
import net.imglib2.IterableRealInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.iterator.IntervalIterator;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.ops.operation.UnaryOutputOperation;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

public final class BinaryKernelFilter<T extends RealType<T>, K extends RandomAccessibleInterval<T> & IterableInterval<T>>
implements UnaryOperation<K, K> {
    private int m_kernelNumDim;
    private final int m_dimIndex0;
    private long m_startOffset;
    private Queue<T>[] m_kernel;
    private ArrayList<T> m_kernelReferenceArray;
    private final UnaryOutputOperation<Iterable<T>, T> m_op;

    public BinaryKernelFilter(Img<BitType> kernel, int dimIndex0, UnaryOutputOperation<Iterable<T>, T> op) {
        this.m_dimIndex0 = dimIndex0;
        this.setupKernel(kernel);
        this.m_op = op;
    }

    public BinaryKernelFilter(Queue<T>[] kernel, int dimIndex0, UnaryOutputOperation<Iterable<T>, T> op) {
        this.m_dimIndex0 = dimIndex0;
        this.m_kernel = kernel;
        this.m_op = op;
    }

    private final void setupKernel(Img<BitType> kernel) {
        int[] kernelDim = new int[kernel.numDimensions()];
        for (int i = 0; i < kernelDim.length; ++i) {
            kernelDim[i] = (int)kernel.dimension(i);
        }
        int[] kernelRadius = (int[])kernelDim.clone();
        for (int i = 0; i < kernelRadius.length; ++i) {
            if (kernelRadius[i] % 2 == 0) {
                throw new IllegalArgumentException("Only odd kernel sizes supported (dim[" + i + "] = " + kernelRadius[i] + ").");
            }
            kernelRadius[i] = kernelRadius[i] / 2;
        }
        int[] lineDim = (int[])kernelDim.clone();
        lineDim[this.m_dimIndex0] = 1;
        IntervalIterator ii = new IntervalIterator(lineDim);
        long dim0 = kernel.dimension(this.m_dimIndex0);
        ArrayList tmp = new ArrayList();
        RandomAccess cur = kernel.randomAccess();
        int count = 0;
        int kernelSize = 0;
        int[] pos = new int[kernel.numDimensions()];
        while (ii.hasNext()) {
            int i;
            ii.fwd();
            cur.setPosition(ii);
            for (long x0 = 0L; x0 < dim0; ++x0) {
                cur.setPosition(x0, this.m_dimIndex0);
                if (((BitType)cur.get()).get()) {
                    ++count;
                    ++kernelSize;
                    continue;
                }
                if (count <= 0) continue;
                ii.localize(pos);
                pos[this.m_dimIndex0] = pos[this.m_dimIndex0] - 1;
                for (i = 0; i < pos.length; ++i) {
                    int n = i;
                    pos[n] = pos[n] - kernelRadius[i];
                }
                tmp.add(new Queue((int[])pos.clone(), count));
                count = 0;
            }
            if (count <= 0) continue;
            ii.localize(pos);
            for (i = 0; i < pos.length; ++i) {
                int n = i;
                pos[n] = pos[n] - kernelRadius[i];
            }
            tmp.add(new Queue((int[])pos.clone(), count));
            count = 0;
        }
        this.m_kernelNumDim = kernel.numDimensions();
        this.m_startOffset = kernel.dimension(this.m_dimIndex0);
        this.m_kernelReferenceArray = new ArrayList(kernelSize);
        this.m_kernel = new Queue[tmp.size()];
        tmp.toArray(this.m_kernel);
    }

    @Override
    public final K compute(K op, K r) {
        int i = 0;
        long dim0 = op.dimension(this.m_dimIndex0);
        for (Queue<T> q : this.m_kernel) {
            q.init((RealType)((RealType)((IterableRealInterval)op).firstElement()).createVariable());
            for (int j = 0; j < q.size(); ++j) {
                this.m_kernelReferenceArray.add(q.getType(j));
            }
        }
        long[] dim = new long[op.numDimensions()];
        op.dimensions(dim);
        dim[this.m_dimIndex0] = 1L;
        IntervalIterator ii = new IntervalIterator(dim);
        RandomAccess cr = r.randomAccess();
        RandomAccess co = Views.extendValue(op, ((RealType)((IterableRealInterval)op).firstElement()).createVariable()).randomAccess();
        while (ii.hasNext()) {
            long x0;
            ii.fwd();
            for (x0 = -this.m_startOffset; x0 < 0L; ++x0) {
                for (Queue<T> q : this.m_kernel) {
                    for (i = 0; i < this.m_kernelNumDim; ++i) {
                        co.setPosition(ii.getLongPosition(i) + (long)q.getOffset(i), i);
                    }
                    while (i < dim.length) {
                        co.setPosition(ii.getLongPosition(i), i);
                        ++i;
                    }
                    co.setPosition(x0 + (long)q.getOffset(this.m_dimIndex0), this.m_dimIndex0);
                    q.circle((RealType)co.get());
                }
            }
            for (x0 = 0L; x0 < dim0; ++x0) {
                for (Queue<T> q : this.m_kernel) {
                    for (i = 0; i < this.m_kernelNumDim; ++i) {
                        co.setPosition(ii.getLongPosition(i) + (long)q.getOffset(i), i);
                    }
                    while (i < dim.length) {
                        co.setPosition(ii.getLongPosition(i), i);
                        ++i;
                    }
                    co.setPosition(x0 + (long)q.getOffset(this.m_dimIndex0), this.m_dimIndex0);
                    q.circle((RealType)co.get());
                }
                cr.setPosition(ii);
                cr.setPosition(x0, this.m_dimIndex0);
                ((RealType)cr.get()).set((Type)this.m_op.compute(this.m_kernelReferenceArray, this.m_op.createEmptyOutput(this.m_kernelReferenceArray)));
            }
        }
        return r;
    }

    @Override
    public UnaryOperation<K, K> copy() {
        return new BinaryKernelFilter<T, K>(this.m_kernel, this.m_dimIndex0, this.m_op);
    }

    final class Queue<Q extends RealType<Q>> {
        private Q m_ret;
        private final int[] m_offset;
        private final Q[] m_queue;
        private int m_index;

        public Queue(int[] offset, int length) {
            this.m_offset = offset;
            this.m_queue = new RealType[length];
        }

        public final Q getType(int i) {
            return this.m_queue[i];
        }

        public final int getOffset(int i) {
            return this.m_offset[i];
        }

        public final int size() {
            return this.m_queue.length;
        }

        public final void init(Q type) {
            this.m_ret = (RealType)type.createVariable();
            for (int i = 0; i < this.m_queue.length; ++i) {
                this.m_queue[i] = (RealType)type.createVariable();
            }
        }

        public final Q circle(Q v) {
            this.m_ret.set(this.m_queue[this.m_index]);
            this.m_queue[this.m_index].set(v);
            this.m_index = (this.m_index + 1) % this.m_queue.length;
            return this.m_ret;
        }
    }
}

