/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.randomaccessibleinterval.unary;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgPlus;
import net.imglib2.labeling.Labeling;
import net.imglib2.labeling.NativeImgLabeling;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.ops.operation.metadata.unary.CopyCalibratedSpace;
import net.imglib2.ops.operation.metadata.unary.CopyImageMetadata;
import net.imglib2.ops.operation.metadata.unary.CopyMetadata;
import net.imglib2.ops.operation.metadata.unary.CopyNamed;
import net.imglib2.ops.operation.metadata.unary.CopySourced;
import net.imglib2.ops.operation.subset.views.ImgPlusView;
import net.imglib2.ops.operation.subset.views.ImgView;
import net.imglib2.ops.operation.subset.views.LabelingView;
import net.imglib2.ops.operation.subset.views.SubsetViews;
import net.imglib2.type.Type;

public final class IterateUnaryOperation<T extends Type<T>, V extends Type<V>, S extends RandomAccessibleInterval<T>, U extends RandomAccessibleInterval<V>>
implements UnaryOperation<S, U> {
    private final ExecutorService m_service;
    private final UnaryOperation<S, U> m_op;
    private final Interval[] m_outIntervals;
    private final Interval[] m_inIntervals;

    public IterateUnaryOperation(UnaryOperation<S, U> op, Interval[] inIntervals) {
        this(op, inIntervals, inIntervals, null);
    }

    public IterateUnaryOperation(UnaryOperation<S, U> op, Interval[] inIntervals, Interval[] outIntervals) {
        this(op, inIntervals, outIntervals, null);
    }

    public IterateUnaryOperation(UnaryOperation<S, U> op, Interval[] inIntervals, ExecutorService service) {
        this(op, inIntervals, inIntervals, service);
    }

    public IterateUnaryOperation(UnaryOperation<S, U> op, Interval[] inIntervals, Interval[] outIntervals, ExecutorService service) {
        if (inIntervals.length != outIntervals.length) {
            throw new IllegalArgumentException("In and out intervals do not match! Most likely an implementation error!");
        }
        this.m_op = op;
        this.m_inIntervals = inIntervals;
        this.m_outIntervals = outIntervals;
        this.m_service = service;
    }

    @Override
    public final U compute(S in, U out) {
        Future[] futures = new Future[this.m_inIntervals.length];
        for (int i = 0; i < this.m_outIntervals.length; ++i) {
            if (Thread.interrupted()) {
                return out;
            }
            OperationTask t = new OperationTask(this, this.m_op, this.createSubType(this.m_inIntervals[i], (RandomAccessibleInterval)in), this.createSubType(this.m_outIntervals[i], (RandomAccessibleInterval)out));
            if (this.m_service != null) {
                if (this.m_service.isShutdown()) {
                    return out;
                }
                futures[i] = this.m_service.submit(t);
                continue;
            }
            t.run();
        }
        if (this.m_service != null) {
            try {
                for (Future f : futures) {
                    if (f.isCancelled()) {
                        return out;
                    }
                    f.get();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return out;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                return out;
            }
        }
        return out;
    }

    private synchronized <TT extends Type<TT>, II extends RandomAccessibleInterval<TT>> II createSubType(Interval i, II in) {
        if (in instanceof Labeling) {
            return (II)new LabelingView(SubsetViews.iterableSubsetView(in, i), ((NativeImgLabeling)in).factory());
        }
        if (in instanceof ImgPlus) {
            ImgPlusView imgPlusView = new ImgPlusView(SubsetViews.iterableSubsetView(in, i), ((ImgPlus)in).factory());
            new CopyMetadata(new CopyNamed(), new CopySourced(), new CopyImageMetadata(), new CopyCalibratedSpace(i)).compute((ImgPlus)in, imgPlusView);
            return (II)imgPlusView;
        }
        if (in instanceof Img) {
            return (II)new ImgView(SubsetViews.iterableSubsetView(in, i), ((Img)in).factory());
        }
        return (II)SubsetViews.iterableSubsetView(in, i);
    }

    @Override
    public UnaryOperation<S, U> copy() {
        return new IterateUnaryOperation<T, V, S, U>(this.m_op.copy(), this.m_inIntervals, this.m_outIntervals, this.m_service);
    }

    private static class OperationTask
    implements Runnable {
        private final UnaryOperation<S, U> m_op;
        private final S m_in;
        private final U m_out;
        final /* synthetic */ IterateUnaryOperation this$0;

        public OperationTask(UnaryOperation<S, U> op, S in, U out) {
            this.this$0 = var1_1;
            this.m_in = in;
            this.m_out = out;
            this.m_op = op.copy();
        }

        @Override
        public void run() {
            this.m_op.compute(this.m_in, this.m_out);
        }
    }
}

