/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.randomaccessibleinterval.unary;

import net.imglib2.img.Img;
import net.imglib2.ops.img.BinaryOperationAssignment;
import net.imglib2.ops.img.UnaryOperationAssignment;
import net.imglib2.ops.operation.BinaryOperation;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.ops.operation.img.unary.ImgCopyOperation;
import net.imglib2.ops.operation.randomaccessibleinterval.unary.GrayscaleReconstructionByDilation;
import net.imglib2.ops.operation.real.binary.RealSubtract;
import net.imglib2.ops.types.ConnectedType;
import net.imglib2.type.numeric.RealType;

public class HDomeTransformation<T extends RealType<T>>
implements UnaryOperation<Img<T>, Img<T>> {
    private final ConnectedType m_type;
    private final double m_height;
    private final double m_substractBefore;

    public HDomeTransformation(ConnectedType type, double height, double substractBefore) {
        this.m_type = type;
        this.m_height = height;
        this.m_substractBefore = substractBefore;
    }

    @Override
    public Img<T> compute(Img<T> input, Img<T> output) {
        if (this.m_substractBefore > 0.0) {
            Img<T> noSingular = input.factory().create(input, ((RealType)input.firstElement()).createVariable());
            this.getRegionalMaxima(input, this.m_substractBefore, noSingular);
            input = this.subtract(input, noSingular);
        }
        if (this.m_height > 0.0) {
            output = this.getRegionalMaxima(input, this.m_height, output);
        } else {
            new ImgCopyOperation<T>().compute(input, output);
        }
        return output;
    }

    @Override
    public UnaryOperation<Img<T>, Img<T>> copy() {
        return new HDomeTransformation<T>(this.m_type, this.m_height, this.m_substractBefore);
    }

    private Img<T> getRegionalMaxima(Img<T> img, double height, Img<T> output) {
        SubstractConstantOp op = new SubstractConstantOp(height);
        op.compute(img, output);
        GrayscaleReconstructionByDilation op2 = new GrayscaleReconstructionByDilation(this.m_type);
        output = op2.compute(img, output);
        return this.subtract(img, output);
    }

    private Img<T> subtract(Img<T> minuend, Img<T> subtrahend) {
        SubstractImgFromImgOp subtract = new SubstractImgFromImgOp();
        subtract.compute(minuend, subtrahend, subtrahend);
        return subtrahend;
    }

    private class SubstractImgFromImgOp
    implements BinaryOperation<Img<T>, Img<T>, Img<T>> {
        private SubstractImgFromImgOp() {
        }

        @Override
        public Img<T> compute(Img<T> input1, Img<T> input2, Img<T> output) {
            new BinaryOperationAssignment(new RealSubtract()).compute(input1, input2, output);
            return output;
        }

        @Override
        public BinaryOperation<Img<T>, Img<T>, Img<T>> copy() {
            return new SubstractImgFromImgOp();
        }
    }

    private class RealSubtractConstantBounded<I extends RealType<I>>
    implements UnaryOperation<I, I> {
        private final double constant;

        public RealSubtractConstantBounded(double constant) {
            this.constant = constant;
        }

        @Override
        public I compute(I input, I output) {
            double val = Math.max(output.getMinValue(), input.getRealDouble() - this.constant);
            output.setReal(val);
            return output;
        }

        @Override
        public UnaryOperation<I, I> copy() {
            return new RealSubtractConstantBounded<I>(this.constant);
        }
    }

    private class SubstractConstantOp
    implements UnaryOperation<Img<T>, Img<T>> {
        private final double height;

        public SubstractConstantOp(double height) {
            this.height = height;
        }

        @Override
        public Img<T> compute(Img<T> input, Img<T> output) {
            new UnaryOperationAssignment(new RealSubtractConstantBounded(this.height)).compute(input, output);
            return output;
        }

        @Override
        public UnaryOperation<Img<T>, Img<T>> copy() {
            return new SubstractConstantOp(this.height);
        }
    }
}

