/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.randomaccessibleinterval.unary;

import java.awt.Point;
import java.awt.Polygon;
import java.util.ArrayList;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.type.logic.BitType;

public class ConvexHull2D<K extends RandomAccessibleInterval<BitType> & IterableInterval<BitType>>
implements UnaryOperation<K, K> {
    private final int m_dimX;
    private final int m_dimY;
    private final boolean m_fill;
    private int[] p1 = new int[2];
    private int[] p2 = new int[2];

    public ConvexHull2D(int dimX, int dimY, boolean fill) {
        this.m_dimX = dimX;
        this.m_dimY = dimY;
        this.m_fill = fill;
    }

    @Override
    public K compute(K in, K r) {
        Cursor cur = ((IterableInterval)in).localizingCursor();
        ArrayList<Point> points = new ArrayList<Point>();
        while (cur.hasNext()) {
            cur.fwd();
            if (!((BitType)cur.get()).get()) continue;
            points.add(new Point(cur.getIntPosition(this.m_dimX), cur.getIntPosition(this.m_dimY)));
        }
        points = this.quickHull(points);
        Polygon poly = new Polygon();
        for (Point p : points) {
            poly.addPoint(p.x, p.y);
        }
        Cursor resCur = ((IterableInterval)r).localizingCursor();
        if (this.m_fill) {
            while (resCur.hasNext()) {
                resCur.fwd();
                if (!poly.contains(resCur.getIntPosition(this.m_dimX), resCur.getIntPosition(this.m_dimY))) continue;
                ((BitType)resCur.get()).set(true);
            }
        } else {
            RandomAccess<BitType> ra = r.randomAccess();
            for (int i = 0; i < poly.npoints - 1; ++i) {
                this.drawLine(ra, poly, i, i + 1, this.m_dimX, this.m_dimY);
            }
            if (poly.npoints > 0) {
                this.drawLine(ra, poly, poly.npoints - 1, 0, this.m_dimX, this.m_dimY);
            }
        }
        return r;
    }

    private void drawLine(RandomAccess<BitType> ra, Polygon poly, int idx1, int idx2, int dimX, int dimY) {
        int[][] points;
        this.p1[0] = poly.xpoints[idx1];
        this.p1[1] = poly.ypoints[idx1];
        this.p2[0] = poly.xpoints[idx2];
        this.p2[1] = poly.ypoints[idx2];
        for (int[] p : points = this.rasterizeLine(this.p1, this.p2)) {
            ra.setPosition(p[0], dimX);
            ra.setPosition(p[1], dimY);
            ((BitType)ra.get()).set(true);
        }
    }

    private ArrayList<Point> quickHull(ArrayList<Point> points) {
        ArrayList<Point> convexHull = new ArrayList<Point>();
        if (points.size() < 3) {
            return (ArrayList)points.clone();
        }
        int minPoint = -1;
        int maxPoint = -1;
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        for (int i = 0; i < points.size(); ++i) {
            if (points.get((int)i).x < minX) {
                minX = points.get((int)i).x;
                minPoint = i;
            }
            if (points.get((int)i).x <= maxX) continue;
            maxX = points.get((int)i).x;
            maxPoint = i;
        }
        Point A = points.get(minPoint);
        Point B = points.get(maxPoint);
        convexHull.add(A);
        convexHull.add(B);
        points.remove(A);
        points.remove(B);
        ArrayList<Point> leftSet = new ArrayList<Point>();
        ArrayList<Point> rightSet = new ArrayList<Point>();
        for (int i = 0; i < points.size(); ++i) {
            Point p = points.get(i);
            if (this.pointLocation(A, B, p) == -1) {
                leftSet.add(p);
                continue;
            }
            rightSet.add(p);
        }
        this.hullSet(A, B, rightSet, convexHull);
        this.hullSet(B, A, leftSet, convexHull);
        return convexHull;
    }

    private int distance(Point A, Point B, Point C) {
        int ABx = B.x - A.x;
        int ABy = B.y - A.y;
        int num = ABx * (A.y - C.y) - ABy * (A.x - C.x);
        if (num < 0) {
            num = -num;
        }
        return num;
    }

    private void hullSet(Point A, Point B, ArrayList<Point> set, ArrayList<Point> hull) {
        int insertPosition = hull.indexOf(B);
        if (set.size() == 0) {
            return;
        }
        if (set.size() == 1) {
            Point p = set.get(0);
            set.remove(p);
            hull.add(insertPosition, p);
            return;
        }
        int dist = Integer.MIN_VALUE;
        int furthestPoint = -1;
        for (int i = 0; i < set.size(); ++i) {
            Point p = set.get(i);
            int distance = this.distance(A, B, p);
            if (distance <= dist) continue;
            dist = distance;
            furthestPoint = i;
        }
        Point P = set.get(furthestPoint);
        set.remove(furthestPoint);
        hull.add(insertPosition, P);
        ArrayList<Point> leftSetAP = new ArrayList<Point>();
        for (int i = 0; i < set.size(); ++i) {
            Point M = set.get(i);
            if (this.pointLocation(A, P, M) != 1) continue;
            leftSetAP.add(M);
        }
        ArrayList<Point> leftSetPB = new ArrayList<Point>();
        for (int i = 0; i < set.size(); ++i) {
            Point M = set.get(i);
            if (this.pointLocation(P, B, M) != 1) continue;
            leftSetPB.add(M);
        }
        this.hullSet(A, P, leftSetAP, hull);
        this.hullSet(P, B, leftSetPB, hull);
    }

    public int pointLocation(Point A, Point B, Point P) {
        int cp1 = (B.x - A.x) * (P.y - A.y) - (B.y - A.y) * (P.x - A.x);
        return cp1 > 0 ? 1 : -1;
    }

    @Override
    public UnaryOperation<K, K> copy() {
        return new ConvexHull2D<K>(this.m_dimX, this.m_dimY, this.m_fill);
    }

    public int[][] rasterizeLine(int[] point1, int[] point2) {
        int ytmp;
        int xtmp;
        int l = Math.max(Math.abs(point1[0] - point2[0]), Math.abs(point1[1] - point2[1]));
        int[][] res = new int[l][2];
        int count = 0;
        int dy = point2[1] - point1[1];
        int dx = point2[0] - point1[0];
        int incx = dx > 0 ? 1 : -1;
        int incy = dy > 0 ? 1 : -1;
        if (Math.abs(dy) < Math.abs(dx)) {
            int error = -Math.abs(dx);
            int delta = 2 * Math.abs(dy);
            int step = 2 * error;
            for (xtmp = point1[0]; xtmp != point2[0]; xtmp += incx) {
                res[count] = new int[]{xtmp, ytmp};
                ++count;
                if ((error += delta) <= 0) continue;
                ytmp += incy;
                error += step;
            }
        } else {
            int error = -Math.abs(dy);
            int delta = 2 * Math.abs(dx);
            int step = 2 * error;
            for (ytmp = point1[1]; ytmp != point2[1]; ytmp += incy) {
                res[count] = new int[]{xtmp, ytmp};
                ++count;
                if ((error += delta) <= 0) continue;
                xtmp += incx;
                error += step;
            }
        }
        return res;
    }
}

