/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.randomaccessibleinterval.unary;

import net.imglib2.IterableInterval;
import net.imglib2.IterableRealInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

public class CLAHE<T extends RealType<T>, K extends RandomAccessibleInterval<T> & IterableInterval<T>>
implements UnaryOperation<K, K> {
    private int m_ctxNrX = 8;
    private int m_ctxNrY = 8;
    private final int histNrBins = 256;
    private final float clipLimit = 3.0f;
    private boolean m_enableClipping = true;
    private RandomAccess<T> m_srcRa;
    private RandomAccess<T> m_resRa;
    private int imgWidth;
    private int imgHeight;
    private int m_imgGrayMin = 0;
    private int m_imgGrayMax = 255;
    private int m_imgNrGrayVals;
    private int ctxXSize;
    private int ctxYSize;
    private int ctxNrPixels;
    private int absClipLimit;
    private double m_scale;
    private int[] histograms;

    public CLAHE(int ctxNrX, int ctxNrY, boolean enableClipping) {
        this.m_ctxNrX = ctxNrX;
        this.m_ctxNrY = ctxNrY;
        this.m_enableClipping = enableClipping;
    }

    @Override
    public K compute(K in, K r) {
        RealType type = (RealType)((RealType)((IterableRealInterval)r).firstElement()).createVariable();
        this.m_imgGrayMin = (int)Math.round(type.getMinValue());
        this.m_imgGrayMax = (int)Math.round(type.getMaxValue());
        this.m_imgNrGrayVals = this.m_imgGrayMax - this.m_imgGrayMin + 1;
        this.m_scale = 255 / (this.m_imgGrayMax - this.m_imgGrayMin);
        if (r.numDimensions() > 2) {
            throw new IllegalArgumentException("CLAHE only supports 2-dim images.");
        }
        type.setReal(this.m_imgGrayMin);
        this.m_srcRa = in.randomAccess();
        this.m_resRa = r.randomAccess();
        this.imgWidth = (int)r.dimension(0);
        this.imgHeight = (int)r.dimension(1);
        this.ctxXSize = this.imgWidth / this.m_ctxNrX;
        this.ctxYSize = this.imgHeight / this.m_ctxNrY;
        this.ctxNrPixels = this.ctxXSize * this.ctxYSize;
        this.absClipLimit = (int)(3.0f * (float)(this.ctxXSize * this.ctxYSize / 256));
        if (this.m_ctxNrX < 2 || this.m_ctxNrY < 2) {
            throw new IllegalArgumentException("A minimum of two context regions per dimension is required.");
        }
        if (this.m_imgNrGrayVals < 256) {
            throw new IllegalArgumentException("Number of input gray values must be greater than number of histogram bins.");
        }
        if (this.ctxXSize * this.ctxYSize / 256 < 1) {
            throw new IllegalArgumentException("Number of histogram bins is larger than number of pixels in a contextual region.");
        }
        if (this.absClipLimit * 256 < this.ctxNrPixels) {
            throw new IllegalArgumentException("Relative clip limit too low.");
        }
        this.histograms = this.createHistograms(r);
        int xi = 0;
        int yi = 0;
        int histArrayOffset = 0;
        for (yi = 0; yi < this.m_ctxNrY; ++yi) {
            for (xi = 0; xi < this.m_ctxNrX; ++xi) {
                if (this.m_enableClipping) {
                    this.clipHistogram(histArrayOffset);
                }
                this.createCumulativeHistogram(histArrayOffset);
                histArrayOffset += 256;
            }
        }
        this.interpolate();
        return r;
    }

    private void interpolate() {
        int yUp = 0;
        int yBo = 0;
        int xLeft = 0;
        int xRight = 0;
        int subXSize = 0;
        int subYSize = 0;
        int imgPos = 0;
        for (int iy = 0; iy <= this.m_ctxNrY; ++iy) {
            if (iy == 0) {
                subYSize = this.ctxYSize >> 1;
                yUp = 0;
                yBo = 0;
            } else if (iy == this.m_ctxNrY) {
                subYSize = this.ctxYSize >> 1;
                yBo = yUp = this.m_ctxNrY - 1;
            } else {
                subYSize = this.ctxYSize;
                yUp = iy - 1;
                yBo = yUp + 1;
            }
            for (int ix = 0; ix <= this.m_ctxNrX; ++ix) {
                if (ix == 0) {
                    subXSize = this.ctxXSize >> 1;
                    xLeft = 0;
                    xRight = 0;
                } else if (ix == this.m_ctxNrX) {
                    subXSize = this.ctxXSize >> 1;
                    xRight = xLeft = this.m_ctxNrX - 1;
                } else {
                    subXSize = this.ctxXSize;
                    xLeft = ix - 1;
                    xRight = xLeft + 1;
                }
                int leftUpper = 256 * (yUp * this.m_ctxNrX + xLeft);
                int rightUpper = 256 * (yUp * this.m_ctxNrX + xRight);
                int leftBottom = 256 * (yBo * this.m_ctxNrX + xLeft);
                int rightBottom = 256 * (yBo * this.m_ctxNrX + xRight);
                this.interpolate4regions(leftUpper, rightUpper, leftBottom, rightBottom, subXSize, subYSize, imgPos);
                imgPos += subXSize;
            }
            imgPos += (subYSize - 1) * this.imgWidth;
        }
    }

    private void interpolate4regions(int leftUpper, int rightUpper, int leftBottom, int rightBottom, int subXSize, int subYSize, int p) {
        int incr = this.imgWidth - subXSize;
        int num = subXSize * subYSize;
        int invCoefY = subYSize;
        for (int coefY = 0; coefY < subYSize; ++coefY) {
            int invCoefX = subXSize;
            this.m_srcRa.setPosition(p, 0);
            for (int coefX = 0; coefX < subXSize; ++coefX) {
                this.m_srcRa.setPosition(p, 0);
                int gray = this.valueToBin(((RealType)this.m_srcRa.get()).getRealFloat());
                int newValue = (invCoefY * (invCoefX * this.histograms[leftUpper + gray] + coefX * this.histograms[rightUpper + gray]) + coefY * (invCoefX * this.histograms[leftBottom + gray] + coefX * this.histograms[rightBottom + gray])) / num;
                this.m_resRa.setPosition(this.m_srcRa);
                ((RealType)this.m_resRa.get()).setReal(newValue);
                ++p;
                --invCoefX;
            }
            --invCoefY;
            p += incr;
        }
    }

    private int[] createHistograms(K img) {
        RandomAccess ra = Views.extendPeriodic(img).randomAccess();
        int[] histograms = new int[this.m_ctxNrX * this.m_ctxNrY * 256];
        for (int ctxY = 0; ctxY < this.m_ctxNrY; ++ctxY) {
            for (int y = 0; y < this.ctxYSize; ++y) {
                for (int ctxX = 0; ctxX < this.m_ctxNrX; ++ctxX) {
                    for (int x = 0; x < this.ctxXSize; ++x) {
                        int index;
                        ra.fwd(0);
                        int bin = this.valueToBin(((RealType)ra.get()).getRealDouble());
                        int offSet = ctxY * this.m_ctxNrX * 256 + ctxX * 256;
                        int n = index = offSet + bin;
                        histograms[n] = histograms[n] + 1;
                    }
                }
                ra.fwd(1);
            }
        }
        return histograms;
    }

    private void createCumulativeHistogram(int histArrayOffset) {
        float fScale = ((float)this.m_imgGrayMax - (float)this.m_imgGrayMin) / (float)this.ctxNrPixels;
        int sum = 0;
        for (int i = histArrayOffset; i < histArrayOffset + 256; ++i) {
            this.histograms[i] = (int)((float)this.m_imgGrayMin + (float)(sum += this.histograms[i]) * fScale);
            if (this.histograms[i] <= this.m_imgGrayMax) continue;
            this.histograms[i] = this.m_imgGrayMax;
        }
    }

    private void clipHistogram(int histArrayOffset) {
        int totalExcessPxs = 0;
        for (int i = histArrayOffset; i < histArrayOffset + 256; ++i) {
            int binExcessPxs = this.histograms[i] - this.absClipLimit;
            if (binExcessPxs <= 0) continue;
            totalExcessPxs += binExcessPxs;
        }
        int avgBinIncrement = totalExcessPxs / 256;
        int upperBinCapacity = this.absClipLimit - avgBinIncrement;
        for (int i = histArrayOffset; i < histArrayOffset + 256; ++i) {
            if (this.histograms[i] > this.absClipLimit) {
                this.histograms[i] = this.absClipLimit;
                continue;
            }
            if (this.histograms[i] > upperBinCapacity) {
                totalExcessPxs -= this.histograms[i] - upperBinCapacity;
                this.histograms[i] = this.absClipLimit;
                continue;
            }
            totalExcessPxs -= avgBinIncrement;
            int n = i;
            this.histograms[n] = this.histograms[n] + avgBinIncrement;
        }
        int histLimit = histArrayOffset + 256;
        while (totalExcessPxs > 0) {
            for (int currHistPos = histArrayOffset; totalExcessPxs > 0 && currHistPos < histLimit; ++currHistPos) {
                int stepSize = 256 / totalExcessPxs;
                if (stepSize < 1) {
                    stepSize = 1;
                }
                for (int currBin = currHistPos; currBin < histLimit && totalExcessPxs > 0; currBin += stepSize) {
                    if (this.histograms[currBin] >= this.absClipLimit) continue;
                    int n = currBin;
                    this.histograms[n] = this.histograms[n] + 1;
                    --totalExcessPxs;
                }
            }
        }
    }

    private final int valueToBin(double v) {
        return (int)((v - (double)this.m_imgGrayMin) * this.m_scale);
    }

    @Override
    public UnaryOperation<K, K> copy() {
        return new CLAHE<T, K>(this.m_ctxNrX, this.m_ctxNrY, this.m_enableClipping);
    }
}

