/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.randomaccessibleinterval.binary;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgPlus;
import net.imglib2.labeling.Labeling;
import net.imglib2.ops.operation.BinaryOperation;
import net.imglib2.ops.operation.metadata.unary.CopyCalibratedSpace;
import net.imglib2.ops.operation.metadata.unary.CopyImageMetadata;
import net.imglib2.ops.operation.metadata.unary.CopyMetadata;
import net.imglib2.ops.operation.metadata.unary.CopyNamed;
import net.imglib2.ops.operation.metadata.unary.CopySourced;
import net.imglib2.ops.operation.subset.views.ImgPlusView;
import net.imglib2.ops.operation.subset.views.ImgView;
import net.imglib2.ops.operation.subset.views.LabelingView;
import net.imglib2.ops.operation.subset.views.SubsetViews;
import net.imglib2.type.Type;

public final class IterateBinaryOperation<T extends Type<T>, V extends Type<V>, O extends Type<O>, S extends RandomAccessibleInterval<T>, U extends RandomAccessibleInterval<V>, R extends RandomAccessibleInterval<O>>
implements BinaryOperation<S, U, R> {
    private final BinaryOperation<S, U, R> m_op;
    private final Interval[] m_in0Intervals;
    private final Interval[] m_in1Intervals;
    private final Interval[] m_outIntervals;
    private final ExecutorService m_service;

    public IterateBinaryOperation(BinaryOperation<S, U, R> op, Interval[] in0InIntervals, Interval[] in1Intervals, Interval[] outIntervals, ExecutorService service) {
        this.m_op = op;
        this.m_in0Intervals = in0InIntervals;
        this.m_in1Intervals = in1Intervals;
        this.m_outIntervals = outIntervals;
        this.m_service = service;
    }

    public IterateBinaryOperation(BinaryOperation<S, U, R> op, Interval[] in0InIntervals, Interval[] in1Intervals, Interval[] outIntervals) {
        this(op, in0InIntervals, in1Intervals, outIntervals, null);
    }

    public IterateBinaryOperation(BinaryOperation<S, U, R> op, Interval[] inInIntervals, Interval[] outIntervals) {
        this(op, inInIntervals, inInIntervals, outIntervals, null);
    }

    public IterateBinaryOperation(BinaryOperation<S, U, R> op, Interval[] inInIntervals, Interval[] outIntervals, ExecutorService service) {
        this(op, inInIntervals, inInIntervals, outIntervals, service);
    }

    public IterateBinaryOperation(BinaryOperation<S, U, R> op, Interval[] intervals) {
        this(op, intervals, intervals, intervals, null);
    }

    public IterateBinaryOperation(BinaryOperation<S, U, R> op, Interval[] intervals, ExecutorService service) {
        this(op, intervals, intervals, intervals, service);
    }

    @Override
    public final R compute(S in0, U in1, R out) {
        if (this.m_in0Intervals.length != this.m_outIntervals.length || this.m_in0Intervals.length != this.m_in1Intervals.length) {
            throw new IllegalArgumentException("In and out intervals do not match! Most likely an implementation error!");
        }
        Future[] futures = new Future[this.m_in0Intervals.length];
        for (int i = 0; i < this.m_outIntervals.length; ++i) {
            if (Thread.interrupted()) {
                return out;
            }
            OperationTask t = new OperationTask(this, this.m_op, this.createSubType((RandomAccessibleInterval)in0, this.m_in0Intervals[i]), this.createSubType((RandomAccessibleInterval)in1, this.m_in1Intervals[i]), this.createSubType((RandomAccessibleInterval)out, this.m_outIntervals[i]));
            if (this.m_service != null) {
                if (this.m_service.isShutdown()) {
                    return out;
                }
                futures[i] = this.m_service.submit(t);
                continue;
            }
            t.run();
        }
        if (this.m_service != null) {
            try {
                for (Future f : futures) {
                    if (f.isCancelled()) {
                        return out;
                    }
                    f.get();
                }
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                // empty catch block
            }
        }
        return out;
    }

    private synchronized <TT extends Type<TT>, II extends RandomAccessibleInterval<TT>> II createSubType(II in, Interval i) {
        if (in instanceof Labeling) {
            return (II)new LabelingView(SubsetViews.iterableSubsetView(in, i), ((Labeling)in).factory());
        }
        if (in instanceof ImgPlus) {
            ImgPlusView imgPlusView = new ImgPlusView(SubsetViews.iterableSubsetView(in, i), ((ImgPlus)in).factory());
            new CopyMetadata(new CopyNamed(), new CopySourced(), new CopyImageMetadata(), new CopyCalibratedSpace(i)).compute((ImgPlus)in, imgPlusView);
            return (II)imgPlusView;
        }
        if (in instanceof Img) {
            return (II)new ImgView(SubsetViews.iterableSubsetView(in, i), ((Img)in).factory());
        }
        return (II)SubsetViews.iterableSubsetView(in, i);
    }

    @Override
    public BinaryOperation<S, U, R> copy() {
        return new IterateBinaryOperation<T, V, O, S, U, R>(this.m_op.copy(), this.m_in0Intervals, this.m_in1Intervals, this.m_outIntervals, this.m_service);
    }

    private static class OperationTask
    implements Runnable {
        private final BinaryOperation<S, U, R> m_op;
        private final S m_in1;
        private final U m_in2;
        private final R m_out;
        final /* synthetic */ IterateBinaryOperation this$0;

        public OperationTask(BinaryOperation<S, U, R> op, S in1, U in2, R out) {
            this.this$0 = var1_1;
            this.m_in1 = in1;
            this.m_in2 = in2;
            this.m_out = out;
            this.m_op = op.copy();
        }

        @Override
        public void run() {
            this.m_op.compute(this.m_in1, this.m_in2, this.m_out);
        }
    }
}

