/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.randomaccessible.unary;

import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.IterableInterval;
import net.imglib2.IterableRealInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.ops.operation.randomaccessible.binary.FloodFill;
import net.imglib2.ops.types.ConnectedType;
import net.imglib2.type.logic.BitType;

public final class FillHoles<K extends RandomAccessible<BitType> & IterableInterval<BitType>>
implements UnaryOperation<K, K> {
    private final ConnectedType m_connectedType;

    public FillHoles(ConnectedType connectedType) {
        this.m_connectedType = connectedType;
    }

    @Override
    public final K compute(K op, K r) {
        if (!((IterableRealInterval)r).iterationOrder().equals(((IterableRealInterval)op).iterationOrder())) {
            throw new IllegalStateException("Intervals are not compatible (IterationOrder)");
        }
        FloodFill ff = new FloodFill(this.m_connectedType);
        long[] dim = new long[r.numDimensions()];
        ((Dimensions)r).dimensions(dim);
        Cursor rc = ((IterableInterval)r).cursor();
        Cursor opc = ((IterableInterval)op).localizingCursor();
        while (rc.hasNext()) {
            ((BitType)rc.next()).setOne();
        }
        rc.reset();
        while (rc.hasNext()) {
            rc.next();
            opc.next();
            if (!((BitType)rc.get()).get() || ((BitType)opc.get()).get()) continue;
            boolean border = false;
            for (int i = 0; i < r.numDimensions(); ++i) {
                if (rc.getLongPosition(i) != 0L && rc.getLongPosition(i) != dim[i] - 1L) continue;
                border = true;
                break;
            }
            if (!border) continue;
            ff.compute(op, rc, r);
        }
        return r;
    }

    @Override
    public UnaryOperation<K, K> copy() {
        return new FillHoles<K>(this.m_connectedType);
    }
}

