/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.randomaccessible.binary;

import java.util.Arrays;
import java.util.LinkedList;
import net.imglib2.Dimensions;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.ops.operation.BinaryOperation;
import net.imglib2.ops.types.ConnectedType;
import net.imglib2.type.numeric.IntegerType;

public final class FloodFill<T extends IntegerType<T>, K extends RandomAccessible<T> & IterableInterval<T>>
implements BinaryOperation<K, Localizable, K> {
    private final ConnectedType m_type;

    public FloodFill(ConnectedType type) {
        this.m_type = type;
    }

    @Override
    public final K compute(K op0, Localizable op1, K r) {
        long[] op1pos = new long[op1.numDimensions()];
        op1.localize(op1pos);
        this.compute(op0, op1pos, r);
        return r;
    }

    @Override
    public final void compute(K op0, long[] op1, K r) {
        RandomAccess rc = r.randomAccess();
        RandomAccess op0c = op0.randomAccess();
        op0c.setPosition(op1);
        IntegerType floodVal = (IntegerType)((IntegerType)op0c.get()).copy();
        LinkedList<Object> q = new LinkedList<Object>();
        q.addFirst(op1.clone());
        long[] perm = new long[r.numDimensions()];
        block3: while (!q.isEmpty()) {
            int j;
            long[] nextPos;
            long[] pos = (long[])q.removeLast();
            rc.setPosition(pos);
            if (((IntegerType)rc.get()).compareTo(floodVal) == 0) continue;
            op0c.setPosition(pos);
            if (((IntegerType)op0c.get()).compareTo(floodVal) != 0) continue;
            ((IntegerType)rc.get()).set(floodVal);
            switch (this.m_type) {
                case EIGHT_CONNECTED: {
                    Arrays.fill(perm, -1L);
                    int i = r.numDimensions() - 1;
                    block4: while (i > -1) {
                        nextPos = (long[])pos.clone();
                        boolean add = true;
                        for (j = 0; j < r.numDimensions(); ++j) {
                            int n = j;
                            nextPos[n] = nextPos[n] + perm[j];
                            if (nextPos[j] >= 0L && nextPos[j] < ((Dimensions)r).dimension(j)) continue;
                            add = false;
                            break;
                        }
                        if (add) {
                            q.addFirst(nextPos);
                        }
                        for (i = perm.length - 1; i > -1; --i) {
                            if (perm[i] >= 1L) continue;
                            int n = i;
                            perm[n] = perm[n] + 1L;
                            for (j = i + 1; j < perm.length; ++j) {
                                perm[j] = -1L;
                            }
                            continue block4;
                        }
                    }
                    continue block3;
                }
            }
            for (j = 0; j < r.numDimensions(); ++j) {
                if (pos[j] + 1L < ((Dimensions)r).dimension(j)) {
                    nextPos = (long[])pos.clone();
                    int n = j;
                    nextPos[n] = nextPos[n] + 1L;
                    q.addFirst(nextPos);
                }
                if (pos[j] - 1L < 0L) continue;
                nextPos = (long[])pos.clone();
                int n = j;
                nextPos[n] = nextPos[n] - 1L;
                q.addFirst(nextPos);
            }
        }
    }

    @Override
    public BinaryOperation<K, Localizable, K> copy() {
        return new FloodFill<T, K>(this.m_type);
    }
}

