/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.metadata.unary;

import net.imglib2.Interval;
import net.imglib2.meta.CalibratedSpace;
import net.imglib2.ops.operation.UnaryOperation;

public class CopyCalibratedSpace<CS extends CalibratedSpace>
implements UnaryOperation<CS, CS> {
    private Interval interval;

    public CopyCalibratedSpace() {
        this.interval = null;
    }

    public CopyCalibratedSpace(Interval interval) {
        this.interval = interval;
    }

    @Override
    public CS compute(CS input, CS output) {
        int offset = 0;
        for (int d = 0; d < input.numDimensions(); ++d) {
            if (this.interval != null && this.interval.dimension(d) == 1L) {
                ++offset;
                continue;
            }
            output.setAxis(input.axis(d), d - offset);
            output.setCalibration(input.calibration(d), d - offset);
        }
        return output;
    }

    @Override
    public UnaryOperation<CS, CS> copy() {
        return new CopyCalibratedSpace<CS>();
    }
}

