/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.labeling.unary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.labeling.Labeling;
import net.imglib2.labeling.LabelingType;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.ops.types.ConnectedType;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.view.Views;

public class ShrinkLabeling<L extends Comparable<L>>
implements UnaryOperation<Labeling<L>, Labeling<L>> {
    private final ConnectedType m_ct;
    private final int m_numIterations;

    public ShrinkLabeling(ConnectedType ct, int numIterations) {
        this.m_ct = ct;
        this.m_numIterations = numIterations;
    }

    @Override
    public Labeling<L> compute(Labeling<L> op, Labeling<L> r) {
        RandomAccess opRa = Views.extendValue(op, new LabelingType(new ArrayList())).randomAccess();
        RandomAccess resRa = Views.extendValue(r, new LabelingType(new ArrayList())).randomAccess();
        int[] pos = new int[op.numDimensions()];
        HashSet<int[]> nextSeeds = new HashSet<int[]>();
        for (int i = 0; i < this.m_numIterations; ++i) {
            Cursor labelingCursor = op.cursor();
            if (i == 0) {
                if (this.m_ct == ConnectedType.FOUR_CONNECTED) {
                    while (labelingCursor.hasNext()) {
                        labelingCursor.fwd();
                        if (((LabelingType)labelingCursor.get()).getLabeling().isEmpty()) {
                            resRa.setPosition(labelingCursor);
                            ((LabelingType)resRa.get()).setLabeling(((LabelingType)resRa.get()).getMapping().emptyList());
                            continue;
                        }
                        opRa.setPosition(labelingCursor);
                        opRa.localize(pos);
                        nextSeeds.addAll(this.operate4Connected(pos, ((LabelingType)labelingCursor.get()).getLabeling(), (OutOfBounds<LabelingType<L>>)opRa, (OutOfBounds<LabelingType<L>>)resRa));
                    }
                    continue;
                }
                if (this.m_ct != ConnectedType.EIGHT_CONNECTED) continue;
                while (labelingCursor.hasNext()) {
                    labelingCursor.fwd();
                    if (((LabelingType)labelingCursor.get()).getLabeling().isEmpty()) {
                        resRa.setPosition(labelingCursor);
                        ((LabelingType)resRa.get()).setLabeling(((LabelingType)resRa.get()).getMapping().emptyList());
                        continue;
                    }
                    opRa.setPosition(labelingCursor);
                    opRa.localize(pos);
                    nextSeeds.addAll(this.operate8Connected(pos, ((LabelingType)labelingCursor.get()).getLabeling(), (OutOfBounds<LabelingType<L>>)opRa, (OutOfBounds<LabelingType<L>>)resRa));
                }
                continue;
            }
            HashSet<int[]> currentSeeds = new HashSet<int[]>();
            currentSeeds.addAll(nextSeeds);
            nextSeeds.clear();
            if (this.m_ct == ConnectedType.FOUR_CONNECTED) {
                for (int[] currentSeed : currentSeeds) {
                    resRa.setPosition(currentSeed);
                    nextSeeds.addAll(this.operate4Connected(currentSeed, ((LabelingType)resRa.get()).getLabeling(), (OutOfBounds<LabelingType<L>>)resRa, (OutOfBounds<LabelingType<L>>)resRa));
                }
            }
            if (this.m_ct != ConnectedType.EIGHT_CONNECTED) continue;
            for (int[] currentSeed : currentSeeds) {
                resRa.setPosition(currentSeed);
                nextSeeds.addAll(this.operate8Connected(currentSeed, ((LabelingType)resRa.get()).getLabeling(), (OutOfBounds<LabelingType<L>>)resRa, (OutOfBounds<LabelingType<L>>)resRa));
            }
        }
        return r;
    }

    private synchronized Collection<int[]> operate4Connected(int[] currentPos, List<L> currentLabeling, OutOfBounds<LabelingType<L>> opRa, OutOfBounds<LabelingType<L>> resRa) {
        ArrayList<int[]> nextSeeds = new ArrayList<int[]>();
        opRa.setPosition(currentPos[0] - 1, 0);
        if (!((LabelingType)opRa.get()).getLabeling().isEmpty()) {
            opRa.setPosition(currentPos[0] + 1, 0);
            if (!((LabelingType)opRa.get()).getLabeling().isEmpty()) {
                opRa.setPosition(currentPos[0], 0);
                opRa.setPosition(currentPos[1] - 1, 1);
                if (!((LabelingType)opRa.get()).getLabeling().isEmpty()) {
                    opRa.setPosition(currentPos[1] + 1, 1);
                    if (!((LabelingType)opRa.get()).getLabeling().isEmpty()) {
                        nextSeeds.add((int[])currentPos.clone());
                    }
                }
            }
        }
        resRa.setPosition(currentPos);
        if (nextSeeds.size() == 0) {
            ((LabelingType)resRa.get()).setLabeling(((LabelingType)opRa.get()).getMapping().emptyList());
        } else {
            ((LabelingType)resRa.get()).setLabeling(currentLabeling);
        }
        return nextSeeds;
    }

    private synchronized Collection<int[]> operate8Connected(int[] currentPos, List<L> currentLabeling, OutOfBounds<LabelingType<L>> opRa, OutOfBounds<LabelingType<L>> resRa) {
        ArrayList<int[]> nextSeeds = new ArrayList<int[]>();
        opRa.setPosition(currentPos[0] - 1, 0);
        if (!((LabelingType)opRa.get()).getLabeling().isEmpty()) {
            opRa.setPosition(currentPos[0] + 1, 0);
            if (!((LabelingType)opRa.get()).getLabeling().isEmpty()) {
                opRa.setPosition(currentPos[1] - 1, 1);
                if (!((LabelingType)opRa.get()).getLabeling().isEmpty()) {
                    opRa.setPosition(currentPos[1] + 1, 1);
                    if (!((LabelingType)opRa.get()).getLabeling().isEmpty()) {
                        opRa.setPosition(currentPos[0], 0);
                        if (!((LabelingType)opRa.get()).getLabeling().isEmpty()) {
                            opRa.setPosition(currentPos[0] - 1, 0);
                            if (!((LabelingType)opRa.get()).getLabeling().isEmpty()) {
                                opRa.setPosition(currentPos[1] - 1, 1);
                                if (!((LabelingType)opRa.get()).getLabeling().isEmpty()) {
                                    opRa.setPosition(currentPos[0], 0);
                                    if (!((LabelingType)opRa.get()).getLabeling().isEmpty()) {
                                        nextSeeds.add((int[])currentPos.clone());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        resRa.setPosition(currentPos);
        if (nextSeeds.size() == 0) {
            ((LabelingType)resRa.get()).setLabeling(((LabelingType)opRa.get()).getMapping().emptyList());
        } else {
            ((LabelingType)resRa.get()).setLabeling(currentLabeling);
        }
        return nextSeeds;
    }

    @Override
    public UnaryOperation<Labeling<L>, Labeling<L>> copy() {
        return new ShrinkLabeling<L>(this.m_ct, this.m_numIterations);
    }
}

