/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.labeling.unary;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.labeling.Labeling;
import net.imglib2.labeling.LabelingType;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.ops.operation.randomaccessibleinterval.unary.regiongrowing.AbstractRegionGrowing;
import net.imglib2.util.Pair;

public class GrowLabeling<L extends Comparable<L>>
extends AbstractRegionGrowing<LabelingType<L>, L, Labeling<L>, Labeling<L>> {
    private Cursor<LabelingType<L>> m_seedLabCur;
    private final List<Pair<int[], L>> m_seedingPoints = new ArrayList<Pair<int[], L>>();
    private Iterator<Pair<int[], L>> m_seedIterator;
    private boolean m_initSeeds = true;
    private final int m_numIterations;
    private int m_iterations = 0;

    public GrowLabeling(long[][] structuringElement, int numIterations) {
        super(structuringElement, AbstractRegionGrowing.GrowingMode.SYNCHRONOUS, true);
        this.m_numIterations = numIterations;
    }

    @Override
    protected void initRegionGrowing(Labeling<L> srcImg) {
        this.m_seedLabCur = srcImg.localizingCursor();
    }

    @Override
    protected L nextSeedPosition(int[] seedPos) {
        if (this.m_initSeeds) {
            while (this.m_seedLabCur.hasNext()) {
                this.m_seedLabCur.fwd();
                if (((LabelingType)this.m_seedLabCur.get()).getLabeling().isEmpty()) continue;
                this.m_seedLabCur.localize(seedPos);
                return (L)((Comparable)((LabelingType)this.m_seedLabCur.get()).getLabeling().get(0));
            }
        } else if (this.m_seedIterator.hasNext()) {
            Pair<int[], L> next = this.m_seedIterator.next();
            for (int i = 0; i < seedPos.length; ++i) {
                seedPos[i] = ((int[])next.a)[i];
            }
            return (L)((Comparable)next.b);
        }
        this.m_seedingPoints.clear();
        return null;
    }

    @Override
    protected boolean includeInRegion(int[] oldPos, int[] nextPos, L label) {
        this.m_seedingPoints.add(new Pair<int[], L>(nextPos, label));
        return false;
    }

    @Override
    protected void queueProcessed() {
    }

    @Override
    protected boolean hasMoreSeedingPoints() {
        this.m_initSeeds = false;
        this.m_seedIterator = this.m_seedingPoints.iterator();
        return this.m_iterations++ < this.m_numIterations;
    }

    @Override
    public UnaryOperation<Labeling<L>, Labeling<L>> copy() {
        return new GrowLabeling<L>((long[][])this.m_structuringElement.clone(), this.m_iterations);
    }
}

