/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.labeling.unary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.labeling.Labeling;
import net.imglib2.labeling.LabelingType;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.ops.types.ConnectedType;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.view.Views;

public class ExtendLabeling<L extends Comparable<L>>
implements UnaryOperation<Labeling<L>, Labeling<L>> {
    private final ConnectedType ct;
    private boolean labelingBased;

    public ExtendLabeling(ConnectedType type, boolean labelingBased) {
        this.ct = type;
        this.labelingBased = labelingBased;
    }

    @Override
    public Labeling<L> compute(Labeling<L> op, Labeling<L> r) {
        Collection<L> labels = null;
        labels = op.getLabels();
        HashSet<int[]> newSeeds = new HashSet<int[]>();
        RandomAccess opRa = Views.extendValue(op, new LabelingType(((LabelingType)op.firstElement()).getMapping().emptyList())).randomAccess();
        RandomAccess resRa = Views.extendValue(r, new LabelingType(((LabelingType)op.firstElement()).getMapping().emptyList())).randomAccess();
        IterableInterval<L> ii = null;
        Cursor<L> iiCursor = null;
        int[] pos = new int[op.numDimensions()];
        newSeeds.clear();
        for (Comparable label : labels) {
            ii = op.getIterableRegionOfInterest(label).getIterableIntervalOverROI(op);
            iiCursor = ii.cursor();
            while (iiCursor.hasNext()) {
                iiCursor.fwd();
                opRa.setPosition(iiCursor);
                resRa.setPosition(iiCursor);
                opRa.localize(pos);
                ExtendLabeling.setLabeling(((LabelingType)iiCursor.get()).getLabeling(), resRa, this.labelingBased);
                if (this.ct == ConnectedType.EIGHT_CONNECTED) {
                    newSeeds.addAll(ExtendLabeling.operate8Connected(pos, ((LabelingType)iiCursor.get()).getLabeling(), opRa, resRa, this.labelingBased));
                    continue;
                }
                if (this.ct != ConnectedType.FOUR_CONNECTED) continue;
                newSeeds.addAll(ExtendLabeling.operate4Connected(pos, ((LabelingType)iiCursor.get()).getLabeling(), opRa, resRa, this.labelingBased));
            }
        }
        return r;
    }

    private static synchronized <L extends Comparable<L>> Set<int[]> operate8Connected(int[] currentPos, List<L> currentLabeling, OutOfBounds<LabelingType<L>> opRa, OutOfBounds<LabelingType<L>> resRa, boolean labelingBased) {
        HashSet<int[]> nextSeeds = new HashSet<int[]>();
        opRa.setPosition(currentPos[0] - 1, 0);
        ExtendLabeling.checkAndSet(currentLabeling, currentPos, opRa, resRa, nextSeeds, labelingBased);
        opRa.setPosition(currentPos[0] + 1, 0);
        ExtendLabeling.checkAndSet(currentLabeling, currentPos, opRa, resRa, nextSeeds, labelingBased);
        opRa.setPosition(currentPos[1] - 1, 1);
        opRa.setPosition(currentPos[0] + 1, 0);
        ExtendLabeling.checkAndSet(currentLabeling, currentPos, opRa, resRa, nextSeeds, labelingBased);
        opRa.setPosition(currentPos[1] + 1, 1);
        ExtendLabeling.checkAndSet(currentLabeling, currentPos, opRa, resRa, nextSeeds, labelingBased);
        opRa.setPosition(currentPos[0], 0);
        opRa.setPosition(currentPos[1] + 1, 1);
        ExtendLabeling.checkAndSet(currentLabeling, currentPos, opRa, resRa, nextSeeds, labelingBased);
        opRa.setPosition(currentPos[0] - 1, 0);
        ExtendLabeling.checkAndSet(currentLabeling, currentPos, opRa, resRa, nextSeeds, labelingBased);
        opRa.setPosition(currentPos[1] - 1, 1);
        ExtendLabeling.checkAndSet(currentLabeling, currentPos, opRa, resRa, nextSeeds, labelingBased);
        opRa.setPosition(currentPos[0], 0);
        opRa.setPosition(currentPos[1] - 1, 1);
        ExtendLabeling.checkAndSet(currentLabeling, currentPos, opRa, resRa, nextSeeds, labelingBased);
        return nextSeeds;
    }

    private static synchronized <L extends Comparable<L>> void checkAndSet(List<L> currentLabeling, int[] currentPos, OutOfBounds<LabelingType<L>> opRa, OutOfBounds<LabelingType<L>> resRa, Set<int[]> nextSeeds, boolean labelingBased) {
        if (!((LabelingType)opRa.get()).getLabeling().containsAll(currentLabeling) && !opRa.isOutOfBounds()) {
            resRa.setPosition(opRa);
            int[] tmpPos = (int[])currentPos.clone();
            resRa.localize(tmpPos);
            ExtendLabeling.setLabeling(currentLabeling, resRa, labelingBased);
            nextSeeds.add((int[])tmpPos.clone());
        }
    }

    private static synchronized <L extends Comparable<L>> Collection<int[]> operate4Connected(int[] currentPos, List<L> currentLabeling, OutOfBounds<LabelingType<L>> opRa, OutOfBounds<LabelingType<L>> resRa, boolean labelingBased) {
        HashSet<int[]> nextSeeds = new HashSet<int[]>();
        opRa.setPosition(currentPos[0] - 1, 0);
        ExtendLabeling.checkAndSet(currentLabeling, currentPos, opRa, resRa, nextSeeds, labelingBased);
        opRa.setPosition(currentPos[0] + 1, 0);
        ExtendLabeling.checkAndSet(currentLabeling, currentPos, opRa, resRa, nextSeeds, labelingBased);
        opRa.setPosition(currentPos[0], 0);
        opRa.setPosition(currentPos[1] - 1, 1);
        ExtendLabeling.checkAndSet(currentLabeling, currentPos, opRa, resRa, nextSeeds, labelingBased);
        opRa.setPosition(currentPos[1] + 1, 1);
        ExtendLabeling.checkAndSet(currentLabeling, currentPos, opRa, resRa, nextSeeds, labelingBased);
        return nextSeeds;
    }

    private static synchronized <L extends Comparable<L>> void setLabeling(List<L> currentLabels, RandomAccess<LabelingType<L>> resRa, boolean labelingBased) {
        List labeling = ((LabelingType)resRa.get()).getLabeling();
        if (!labeling.isEmpty() && !labelingBased) {
            return;
        }
        HashSet<Object> tmpLabels = new HashSet<Object>();
        tmpLabels.clear();
        tmpLabels.addAll(currentLabels);
        tmpLabels.addAll(labeling);
        ((LabelingType)resRa.get()).setLabeling(new ArrayList(tmpLabels));
    }

    @Override
    public UnaryOperation<Labeling<L>, Labeling<L>> copy() {
        return new ExtendLabeling<L>(this.ct, this.labelingBased);
    }
}

