/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.labeling.unary;

import java.util.HashSet;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.labeling.Labeling;
import net.imglib2.labeling.LabelingType;
import net.imglib2.ops.operation.UnaryOperation;

public class ExcludeOnEdges<L extends Comparable<L>>
implements UnaryOperation<Labeling<L>, Labeling<L>> {
    @Override
    public Labeling<L> compute(Labeling<L> inLabeling, Labeling<L> outLabeling) {
        if (inLabeling.numDimensions() != 2) {
            throw new IllegalArgumentException("Exclude on edges works only on two dimensional images");
        }
        long[] dims = new long[inLabeling.numDimensions()];
        inLabeling.dimensions(dims);
        HashSet indices = new HashSet();
        RandomAccess outRndAccess = outLabeling.randomAccess();
        RandomAccess inRndAccess = inLabeling.randomAccess();
        Cursor cur = inLabeling.cursor();
        long[] pos = new long[inLabeling.numDimensions()];
        for (int d = 0; d < dims.length; ++d) {
            int i = 0;
            while ((double)i < Math.pow(2.0, dims.length - 1)) {
                int offset = 0;
                for (int dd = 0; dd < dims.length; ++dd) {
                    if (dd == d) {
                        ++offset;
                        continue;
                    }
                    pos[dd] = (double)i % Math.pow(2.0, dd - offset + 1) == 0.0 ? 0L : dims[dd] - 1L;
                }
                pos[d] = 0L;
                int k = 0;
                while ((long)k < dims[d]) {
                    pos[d] = k;
                    inRndAccess.setPosition(pos);
                    if (0 != ((LabelingType)inRndAccess.get()).getLabeling().size()) {
                        indices.add(((LabelingType)inRndAccess.get()).getLabeling());
                    }
                    ++k;
                }
                ++i;
            }
        }
        while (cur.hasNext()) {
            cur.fwd();
            if (indices.contains(((LabelingType)cur.get()).getLabeling())) continue;
            cur.localize(pos);
            outRndAccess.setPosition(pos);
            ((LabelingType)outRndAccess.get()).setLabeling(((LabelingType)cur.get()).getLabeling());
        }
        return outLabeling;
    }

    @Override
    public UnaryOperation<Labeling<L>, Labeling<L>> copy() {
        return new ExcludeOnEdges<L>();
    }
}

