/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.labeling.unary;

import java.util.ArrayList;
import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.labeling.Labeling;
import net.imglib2.labeling.LabelingType;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.ops.operation.randomaccessibleinterval.unary.morph.StructuringElementCursor;
import net.imglib2.view.Views;

public class ErodeLabeling<L extends Comparable<L>>
implements UnaryOperation<Labeling<L>, Labeling<L>> {
    private final long[][] m_struc;
    private final boolean m_labelBased;

    public ErodeLabeling(long[][] structuringElement) {
        this(structuringElement, true);
    }

    public ErodeLabeling(long[][] structuringElement, boolean labelBased) {
        this.m_struc = structuringElement;
        this.m_labelBased = labelBased;
    }

    @Override
    public Labeling<L> compute(Labeling<L> input, Labeling<L> output) {
        if (this.m_labelBased) {
            return this.computeLabelBased(input, output);
        }
        return this.computeBinaryBased(input, output);
    }

    private Labeling<L> computeLabelBased(Labeling<L> input, Labeling<L> output) {
        StructuringElementCursor inStructure = new StructuringElementCursor(Views.extendValue(input, new LabelingType()).randomAccess(), this.m_struc);
        for (Comparable label : input.getLabels()) {
            Cursor<L> out = input.getIterableRegionOfInterest(label).getIterableIntervalOverROI(output).localizingCursor();
            block1: while (out.hasNext()) {
                out.next();
                inStructure.relocate(out);
                while (inStructure.hasNext()) {
                    inStructure.next();
                    if (((LabelingType)inStructure.get()).getLabeling().contains(label)) continue;
                    this.removeLabel((LabelingType)out.get(), label);
                    continue block1;
                }
                this.addLabel((LabelingType)out.get(), label);
            }
        }
        return output;
    }

    private Labeling<L> computeBinaryBased(Labeling<L> input, Labeling<L> output) {
        StructuringElementCursor inStructure = new StructuringElementCursor(Views.extendValue(input, new LabelingType()).randomAccess(), this.m_struc);
        Cursor out = output.localizingCursor();
        block0: while (out.hasNext()) {
            out.next();
            inStructure.relocate(out);
            List center = ((LabelingType)inStructure.get()).getLabeling();
            if (center.isEmpty()) {
                ((LabelingType)out.get()).setLabeling(((LabelingType)out.get()).getMapping().emptyList());
                continue;
            }
            while (inStructure.hasNext()) {
                inStructure.next();
                if (!((LabelingType)inStructure.get()).getLabeling().isEmpty()) continue;
                ((LabelingType)out.get()).setLabeling(((LabelingType)out.get()).getMapping().emptyList());
                continue block0;
            }
            ((LabelingType)out.get()).setLabeling(center);
        }
        return output;
    }

    private void addLabel(LabelingType<L> type, L elmnt) {
        if (type.getLabeling().contains(elmnt)) {
            return;
        }
        List<L> current = type.getLabeling();
        ArrayList<L> tmp = new ArrayList<L>();
        tmp.addAll(current);
        tmp.add(elmnt);
        type.setLabeling(tmp);
    }

    private void removeLabel(LabelingType<L> type, L elmnt) {
        if (!type.getLabeling().contains(elmnt)) {
            return;
        }
        List<L> current = type.getLabeling();
        ArrayList<L> tmp = new ArrayList<L>();
        tmp.addAll(current);
        tmp.remove(elmnt);
        type.setLabeling(tmp);
    }

    @Override
    public UnaryOperation<Labeling<L>, Labeling<L>> copy() {
        return new ErodeLabeling<L>(this.m_struc, this.m_labelBased);
    }
}

