/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.labeling.unary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.labeling.Labeling;
import net.imglib2.labeling.LabelingType;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.ops.operation.randomaccessibleinterval.unary.morph.StructuringElementCursor;
import net.imglib2.view.Views;

public class DilateLabeling<L extends Comparable<L>>
implements UnaryOperation<Labeling<L>, Labeling<L>> {
    private final long[][] m_struc;
    private final boolean m_labelBased;

    private long[][] sortStructuringElement(long[][] structuringElement) {
        ArrayList<long[]> offsets = new ArrayList<long[]>();
        for (long[] off : structuringElement) {
            offsets.add(off);
        }
        Collections.sort(offsets, new Comparator<long[]>(){

            @Override
            public int compare(long[] o1, long[] o2) {
                double dist1 = 0.0;
                double dist2 = 0.0;
                for (int i = 0; i < o1.length; ++i) {
                    dist1 += (double)(o1[i] * o1[i]);
                    dist2 += (double)(o2[i] * o2[i]);
                }
                if ((dist1 = Math.sqrt(dist1)) < (dist2 = Math.sqrt(dist2))) {
                    return -1;
                }
                if (dist1 > dist2) {
                    return 1;
                }
                return 0;
            }
        });
        long[][] struc = new long[offsets.size()][];
        offsets.toArray((T[])struc);
        return struc;
    }

    public DilateLabeling(long[][] structuringElement) {
        this(structuringElement, true);
    }

    public DilateLabeling(long[][] structuringElement, boolean labelBased) {
        this.m_struc = labelBased ? structuringElement : this.sortStructuringElement(structuringElement);
        this.m_labelBased = labelBased;
    }

    @Override
    public Labeling<L> compute(Labeling<L> input, Labeling<L> output) {
        if (this.m_labelBased) {
            return this.computeLabelBased(input, output);
        }
        return this.computeBinaryBased(input, output);
    }

    private Labeling<L> computeLabelBased(Labeling<L> input, Labeling<L> output) {
        StructuringElementCursor outStructure = new StructuringElementCursor(Views.extendValue(output, new LabelingType()).randomAccess(), this.m_struc);
        for (Comparable label : input.getLabels()) {
            Cursor<L> in = input.getIterableRegionOfInterest(label).getIterableIntervalOverROI(input).localizingCursor();
            while (in.hasNext()) {
                in.next();
                outStructure.relocate(in);
                while (outStructure.hasNext()) {
                    outStructure.next();
                    this.addLabel((LabelingType)outStructure.get(), label);
                }
            }
        }
        return output;
    }

    private Labeling<L> computeBinaryBased(Labeling<L> input, Labeling<L> output) {
        StructuringElementCursor inStructure = new StructuringElementCursor(Views.extendValue(input, new LabelingType()).randomAccess(), this.m_struc);
        Cursor out = output.localizingCursor();
        block0: while (out.hasNext()) {
            out.next();
            inStructure.relocate(out);
            List center = ((LabelingType)inStructure.get()).getLabeling();
            if (!center.isEmpty()) continue;
            while (inStructure.hasNext()) {
                inStructure.next();
                if (((LabelingType)inStructure.get()).getLabeling().isEmpty()) continue;
                ((LabelingType)out.get()).set((LabelingType)inStructure.get());
                continue block0;
            }
            ((LabelingType)out.get()).setLabeling(((LabelingType)out.get()).getMapping().emptyList());
        }
        return output;
    }

    private void addLabel(LabelingType<L> type, L elmnt) {
        if (type.getLabeling().contains(elmnt)) {
            return;
        }
        List<L> current = type.getLabeling();
        ArrayList<L> tmp = new ArrayList<L>();
        tmp.addAll(current);
        tmp.add(elmnt);
        type.setLabeling(tmp);
    }

    @Override
    public UnaryOperation<Labeling<L>, Labeling<L>> copy() {
        return new DilateLabeling<L>(this.m_struc);
    }
}

