/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.iterableinterval.unary.multilevelthresholder;

import java.util.Arrays;

public class ThresholdValueCollection {
    private double[] m_thresholdValues;
    private int m_numberOfLevels;

    public ThresholdValueCollection(int numberOfLevels) {
        this.m_thresholdValues = new double[numberOfLevels - 1];
        this.m_numberOfLevels = numberOfLevels;
    }

    public double get(int i) {
        return this.m_thresholdValues[i];
    }

    public void set(int i, double value) {
        this.m_thresholdValues[i] = value;
    }

    public int getNumberOfLevels() {
        return this.m_numberOfLevels;
    }

    public double[] getSortedVector() {
        double[] sortedCopy = (double[])this.m_thresholdValues.clone();
        Arrays.sort(sortedCopy);
        return sortedCopy;
    }

    public void scale(int numBins, double min, double max) {
        double factor = Math.abs(max - min) / (double)numBins;
        for (int i = 0; i < this.m_thresholdValues.length; ++i) {
            this.m_thresholdValues[i] = this.m_thresholdValues[i] * factor;
        }
    }
}

