/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.iterableinterval.unary.multilevelthresholder;

import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.ops.operation.UnaryOutputOperation;
import net.imglib2.ops.operation.iterableinterval.unary.MakeHistogram;
import net.imglib2.ops.operation.iterableinterval.unary.OpsHistogram;
import net.imglib2.ops.operation.iterableinterval.unary.multilevelthresholder.ThresholdValueCollection;
import net.imglib2.type.numeric.RealType;

public class OtsuMultilevelThresholder<T extends RealType<T>, IN extends IterableInterval<T> & RandomAccessibleInterval<T>>
implements UnaryOutputOperation<IN, ThresholdValueCollection> {
    private int m_numberOfLevels;
    private double m_maxValue;
    private double[][] m_p;
    private double[][] m_s;
    private double[][] m_h;
    private int m_numBins;

    public OtsuMultilevelThresholder() {
        this(2, 256);
    }

    public OtsuMultilevelThresholder(int numLevels) {
        this(numLevels, 256);
    }

    public OtsuMultilevelThresholder(int numLevels, int numBins) {
        if (numLevels < 2) {
            throw new IllegalArgumentException("Number of levels must be greater than 1");
        }
        this.m_numberOfLevels = numLevels;
        this.m_numBins = numBins;
    }

    @Override
    public ThresholdValueCollection compute(IN input, ThresholdValueCollection thresholdValues) throws RuntimeException {
        RealType inVar = (RealType)((RealType)input.firstElement()).createVariable();
        OpsHistogram histogram = new MakeHistogram((int)Math.min((double)this.m_numBins, inVar.getMinValue() - inVar.getMaxValue())).compute(input);
        this.m_maxValue = 0.0;
        this.m_p = new double[this.m_numBins + 1][this.m_numBins + 1];
        this.m_s = new double[this.m_numBins + 1][this.m_numBins + 1];
        this.m_h = new double[this.m_numBins + 1][this.m_numBins + 1];
        this.calculatePLookup(histogram);
        this.calculateSLookup(histogram);
        this.calculateHLookup();
        int[] tempThresholdList = new int[this.m_numberOfLevels];
        this.calculateThresholdValues(thresholdValues, 1, this.m_numBins - this.m_numberOfLevels + 1, 0.0, 0, tempThresholdList);
        thresholdValues.scale(this.m_numBins, inVar.getMinValue(), inVar.getMaxValue());
        return thresholdValues;
    }

    private void calculateThresholdValues(ThresholdValueCollection thresholdValues, int start, int end, double curValue, int curIndex, int[] tList) {
        for (int i = start; i < end; ++i) {
            double h1 = this.m_h[start][i];
            double h2 = this.m_h[i + 1][end + 1];
            double h = curValue + h1 + h2;
            tList[curIndex] = i;
            if (curIndex == this.m_numberOfLevels - 2) {
                if (!(h > this.m_maxValue)) continue;
                for (int j = 0; j < this.m_numberOfLevels - 1; ++j) {
                    thresholdValues.set(j, tList[j]);
                }
                this.m_maxValue = h;
                continue;
            }
            this.calculateThresholdValues(thresholdValues, i + 1, end + 1, curValue + h1, curIndex + 1, tList);
        }
    }

    private void calculatePLookup(OpsHistogram histogram) {
        this.m_p[1][0] = 0.0;
        for (int v = 1; v <= this.m_numBins; ++v) {
            this.m_p[1][v] = this.m_p[1][v - 1] + (double)histogram.get(v - 1);
        }
        for (int u = 2; u <= this.m_numBins; ++u) {
            for (int v = 1; v <= this.m_numBins; ++v) {
                this.m_p[u][v] = this.m_p[1][v] - this.m_p[1][u - 1];
            }
        }
    }

    private void calculateSLookup(OpsHistogram histogram) {
        this.m_s[1][0] = 0.0;
        for (int v = 1; v <= this.m_numBins; ++v) {
            this.m_s[1][v] = this.m_s[1][v - 1] + (double)(v * histogram.get(v - 1));
        }
        for (int u = 2; u <= this.m_numBins; ++u) {
            for (int v = 1; v <= this.m_numBins; ++v) {
                this.m_s[u][v] = this.m_s[1][v] - this.m_s[1][u - 1];
            }
        }
    }

    private void calculateHLookup() {
        for (int u = 1; u <= this.m_numBins; ++u) {
            for (int v = 1; v <= this.m_numBins; ++v) {
                this.m_h[u][v] = this.m_s[u][v] * this.m_s[u][v] / this.m_p[u][v];
            }
        }
    }

    @Override
    public ThresholdValueCollection createEmptyOutput(IN in) {
        return new ThresholdValueCollection(this.m_numberOfLevels);
    }

    @Override
    public UnaryOutputOperation<IN, ThresholdValueCollection> copy() {
        return new OtsuMultilevelThresholder<T, IN>(this.m_numberOfLevels, this.m_numBins);
    }

    @Override
    public ThresholdValueCollection compute(IN in) {
        return this.compute(in, this.createEmptyOutput(in));
    }
}

