/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.iterableinterval.unary.multilevelthresholder;

import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.ops.operation.UnaryOutputOperation;
import net.imglib2.ops.operation.iterableinterval.unary.multilevelthresholder.ThresholdValueCollection;
import net.imglib2.type.numeric.RealType;

public class MultilevelThresholderOp<T extends RealType<T>, IN extends IterableInterval<T>, OUT extends IterableInterval<T>>
implements UnaryOperation<IN, OUT> {
    private final UnaryOutputOperation<IN, ThresholdValueCollection> m_op;

    public MultilevelThresholderOp(UnaryOutputOperation<IN, ThresholdValueCollection> op) {
        this.m_op = op;
    }

    @Override
    public UnaryOperation<IN, OUT> copy() {
        return new MultilevelThresholderOp<T, IN, OUT>(this.m_op.copy());
    }

    @Override
    public OUT compute(IN input, OUT out) {
        if (!input.iterationOrder().equals(out.iterationOrder())) {
            throw new IllegalArgumentException("IterationOrders not the same in StandardMultilevelThresholder");
        }
        Cursor outputCursor = out.cursor();
        Cursor inputCursor = input.cursor();
        ThresholdValueCollection thresholdValues = this.m_op.compute(input);
        double[] sortedValues = thresholdValues.getSortedVector();
        while (inputCursor.hasNext()) {
            outputCursor.fwd();
            double value = ((RealType)inputCursor.next()).getRealDouble();
            int idx = 0;
            for (int d = 0; d < sortedValues.length && value > sortedValues[d]; ++d) {
                ++idx;
            }
            ((RealType)outputCursor.get()).setReal(idx);
        }
        return out;
    }
}

