/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.iterableinterval.unary;

import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NearestNeighborInterpolatorFactory;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

public class Resample<T extends RealType<T>, II extends IterableInterval<T> & RandomAccessibleInterval<T>>
implements UnaryOperation<II, II> {
    private final Mode m_mode;

    public Resample(Mode mode) {
        this.m_mode = mode;
    }

    @Override
    public II compute(II op, II res) {
        InterpolatorFactory ifac;
        switch (this.m_mode) {
            case LINEAR: {
                ifac = new NLinearInterpolatorFactory();
                break;
            }
            case NEAREST_NEIGHBOR: {
                ifac = new NearestNeighborInterpolatorFactory();
                break;
            }
            default: {
                RandomAccess srcRA = Views.extendPeriodic((RandomAccessibleInterval)op).randomAccess();
                Cursor resCur = res.localizingCursor();
                while (resCur.hasNext()) {
                    resCur.fwd();
                    srcRA.setPosition(resCur);
                    ((RealType)resCur.get()).set((Type)srcRA.get());
                }
                return res;
            }
        }
        RealRandomAccess inter = ifac.create(Views.extend((RandomAccessibleInterval)op, new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE)));
        Cursor c2 = res.localizingCursor();
        float[] s = new float[res.numDimensions()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = (float)op.dimension(i) / (float)res.dimension(i);
        }
        long[] d = new long[res.numDimensions()];
        while (c2.hasNext()) {
            c2.fwd();
            c2.localize(d);
            for (int i = 0; i < d.length; ++i) {
                inter.setPosition(s[i] * (float)d[i], i);
            }
            ((RealType)c2.get()).set((Type)inter.get());
        }
        return res;
    }

    @Override
    public UnaryOperation<II, II> copy() {
        return new Resample<T, II>(this.m_mode);
    }

    public static enum Mode {
        LINEAR,
        NEAREST_NEIGHBOR,
        PERIODICAL;

    }
}

