/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.iterableinterval.unary;

import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.type.numeric.RealType;

public class QuantileFilter<T extends RealType<T>, K extends IterableInterval<T> & RandomAccessibleInterval<T>>
implements UnaryOperation<K, K> {
    public static final int MIN_DIMS = 2;
    public static final int MAX_DIMS = 2;
    private int m_radius = 3;
    private int m_quantile = 50;

    public QuantileFilter(int radius, int quantile) {
        this.m_radius = radius;
        this.m_quantile = quantile;
    }

    @Override
    public K compute(K src, K res) {
        RandomAccess resAccess = ((RandomAccessible)res).randomAccess();
        RandomAccess srcAccess = ((RandomAccessible)src).randomAccess();
        int n = (int)src.dimension(0);
        int m = (int)src.dimension(1);
        int minx = 0;
        int maxx = (int)src.dimension(0);
        int miny = 0;
        int maxy = (int)src.dimension(1);
        int xrange = n;
        int yrange = m;
        int pixelrange = (int)(((RealType)srcAccess.get()).getMaxValue() - ((RealType)srcAccess.get()).getMinValue());
        QuantileHistogram blockhistogram = new QuantileHistogram(pixelrange);
        QuantileHistogram[] columnhistograms = new QuantileHistogram[xrange];
        for (int i = 0; i < xrange; ++i) {
            columnhistograms[i] = new QuantileHistogram(pixelrange);
        }
        int act_x_radius = 0;
        int act_y_radius = 0;
        for (int i = 0; i < yrange; ++i) {
            int x;
            int j;
            int y = miny + i;
            act_y_radius = y - this.m_radius >= miny ? (y + this.m_radius <= maxy ? this.m_radius : Math.max(0, maxy - y)) : (2 * y <= maxy ? y : Math.max(0, maxy - y));
            blockhistogram.clear();
            for (j = 0; j < xrange; ++j) {
                int pixel;
                int acty;
                x = minx + j;
                act_x_radius = x - this.m_radius >= minx ? (x + this.m_radius <= maxx ? this.m_radius : Math.max(0, maxx - x)) : (2 * x <= maxx ? x : Math.max(0, maxx - x));
                srcAccess.setPosition(x, 0);
                if (i <= this.m_radius) {
                    acty = y + act_y_radius;
                    srcAccess.setPosition(acty, 1);
                    pixel = (int)(((RealType)srcAccess.get()).getRealDouble() - ((RealType)srcAccess.get()).getMinValue());
                    columnhistograms[j].addPixel(pixel);
                    if (--acty <= 0) continue;
                    srcAccess.setPosition(acty, 1);
                    pixel = (int)(((RealType)srcAccess.get()).getRealDouble() - ((RealType)srcAccess.get()).getMinValue());
                    columnhistograms[j].addPixel(pixel);
                    continue;
                }
                if (i >= yrange - this.m_radius) {
                    acty = y - act_y_radius - 1;
                    if (acty < 0) continue;
                    srcAccess.setPosition(acty, 1);
                    pixel = (int)(((RealType)srcAccess.get()).getRealDouble() - ((RealType)srcAccess.get()).getMinValue());
                    columnhistograms[j].subPixel(pixel);
                    if (--acty < 0) continue;
                    srcAccess.setPosition(acty, 1);
                    pixel = (int)(((RealType)srcAccess.get()).getRealDouble() - ((RealType)srcAccess.get()).getMinValue());
                    columnhistograms[j].subPixel(pixel);
                    continue;
                }
                if (y - this.m_radius - 1 >= miny && y - this.m_radius - 1 <= maxy) {
                    srcAccess.setPosition(y - this.m_radius - 1, 1);
                    pixel = (int)(((RealType)srcAccess.get()).getRealDouble() - ((RealType)srcAccess.get()).getMinValue());
                    columnhistograms[j].subPixel(pixel);
                }
                if (y + this.m_radius < miny || y + this.m_radius > maxy) continue;
                srcAccess.setPosition(y + this.m_radius, 1);
                pixel = (int)(((RealType)srcAccess.get()).getRealDouble() - ((RealType)srcAccess.get()).getMinValue());
                columnhistograms[j].addPixel(pixel);
            }
            for (j = 0; j < xrange; ++j) {
                int actx;
                x = minx + j;
                act_x_radius = x - this.m_radius >= minx ? (x + this.m_radius <= maxx ? this.m_radius : Math.max(0, maxx - x)) : (2 * x <= maxx ? x : Math.max(0, maxx - x));
                if (j <= this.m_radius) {
                    actx = x + act_x_radius;
                    if (actx >= minx && actx <= maxx) {
                        blockhistogram.add(columnhistograms[actx - minx]);
                        if (--actx >= minx && actx <= maxx) {
                            blockhistogram.add(columnhistograms[actx - minx]);
                        }
                    }
                } else if (j >= xrange - this.m_radius) {
                    actx = x - act_x_radius - 1;
                    if (actx >= minx && actx <= maxx) {
                        blockhistogram.sub(columnhistograms[actx - minx]);
                        if (--actx >= minx && actx <= maxx) {
                            blockhistogram.sub(columnhistograms[actx - minx]);
                        }
                    }
                } else {
                    if (x - this.m_radius - 1 >= minx && x - this.m_radius - 1 <= maxx) {
                        blockhistogram.sub(columnhistograms[x - minx - this.m_radius - 1]);
                    }
                    if (x + this.m_radius >= minx && x + this.m_radius <= maxx) {
                        blockhistogram.add(columnhistograms[x - minx + this.m_radius]);
                    }
                }
                resAccess.setPosition(x, 0);
                resAccess.setPosition(y, 1);
                ((RealType)resAccess.get()).setReal(blockhistogram.getQuantile(this.m_quantile));
            }
        }
        return res;
    }

    @Override
    public UnaryOperation<K, K> copy() {
        return new QuantileFilter<T, K>(this.m_radius, this.m_quantile);
    }

    class QuantileHistogram {
        private final int m_maxValue;
        private final int[] m_histogram;
        private int m_count;

        public QuantileHistogram(int maxValue) {
            this.m_maxValue = maxValue;
            this.m_histogram = new int[maxValue];
            this.clear();
        }

        public void clear() {
            for (int i = 0; i < this.m_maxValue; ++i) {
                this.m_histogram[i] = 0;
            }
            this.m_count = 0;
        }

        public void add(QuantileHistogram h) {
            int[] histogram = h.getArray();
            if (histogram.length != this.m_histogram.length) {
                return;
            }
            for (int i = 0; i < histogram.length; ++i) {
                int n = i;
                this.m_histogram[n] = this.m_histogram[n] + histogram[i];
                this.m_count += histogram[i];
            }
        }

        public void sub(QuantileHistogram h) {
            int[] histogram = h.getArray();
            if (histogram.length != this.m_histogram.length) {
                return;
            }
            for (int i = 0; i < histogram.length; ++i) {
                int n = i;
                this.m_histogram[n] = this.m_histogram[n] - histogram[i];
                this.m_count -= histogram[i];
            }
        }

        public void addPixel(int pixel) {
            if (pixel < this.m_maxValue) {
                int n = pixel;
                this.m_histogram[n] = this.m_histogram[n] + 1;
                ++this.m_count;
            }
        }

        public void subPixel(int pixel) {
            if (pixel < this.m_maxValue) {
                int n = pixel;
                this.m_histogram[n] = this.m_histogram[n] - 1;
                --this.m_count;
            }
        }

        public int getQuantile(int quantile) {
            int i;
            int actcount = 0;
            int stop = Math.max((int)((double)this.m_count * (double)quantile / 100.0), 1);
            for (i = 0; i < this.m_histogram.length && actcount < stop; actcount += this.m_histogram[i], ++i) {
            }
            if (i > 0) {
                --i;
            }
            return i;
        }

        public int[] getArray() {
            return this.m_histogram;
        }
    }
}

