/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.iterableinterval.unary;

import net.imglib2.type.numeric.RealType;

public final class OpsHistogram {
    private final int[] m_hist;
    private final int m_bins;
    private final double m_min;
    private final double m_max;
    private final double m_scale;

    public OpsHistogram(int[] hist, double min, double max) {
        this.m_bins = hist.length;
        this.m_hist = hist;
        this.m_min = min;
        this.m_max = max;
        this.m_scale = (double)(this.m_bins - 1) / (this.m_max - this.m_min);
    }

    public OpsHistogram(int bins, double min, double max) {
        this(new int[bins], min, max);
    }

    public <T extends RealType<T>> OpsHistogram(int bins, T type) {
        this(new int[bins], type.getMinValue(), type.getMaxValue());
    }

    public <T extends RealType<T>> OpsHistogram(T type) {
        this(256, type);
    }

    public final void clear() {
        for (int i = 0; i < this.m_hist.length; ++i) {
            this.m_hist[i] = 0;
        }
    }

    public final int[] hist() {
        return this.m_hist;
    }

    public final int numBins() {
        return this.m_bins;
    }

    public final double min() {
        return this.m_min;
    }

    public final double max() {
        return this.m_max;
    }

    public final int get(int i) {
        return this.m_hist[i];
    }

    public final void inc(int i) {
        int n = i;
        this.m_hist[n] = this.m_hist[n] + 1;
    }

    public final int getByValue(double v) {
        return this.get(this.valueToBin(v));
    }

    public final void incByValue(double v) {
        this.inc(this.valueToBin(v));
    }

    public final int valueToBin(double v) {
        return (int)((v - this.m_min) * this.m_scale);
    }

    public final double binToValue(int i) {
        return (double)i / this.m_scale + this.m_min;
    }
}

