/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.iterableinterval.unary;

import java.util.Iterator;
import net.imglib2.IterableInterval;
import net.imglib2.ops.operation.UnaryOutputOperation;
import net.imglib2.ops.operation.iterableinterval.unary.MakeHistogram;
import net.imglib2.ops.operation.iterableinterval.unary.OpsHistogram;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Pair;

public final class MinMax<T extends RealType<T>>
implements UnaryOutputOperation<IterableInterval<T>, Pair<T, T>> {
    private double m_saturation;
    private MakeHistogram<T> m_histOp;

    public MinMax(double saturation, T type) {
        this.m_saturation = saturation;
        if (saturation != 0.0) {
            int bins = !(type.getMaxValue() < 2.147483647E9) ? 65534 : (int)(type.getMaxValue() - type.getMinValue() + 1.0);
            this.m_histOp = new MakeHistogram(bins);
        }
    }

    public MinMax() {
        this(0.0, null);
    }

    @Override
    public Pair<T, T> createEmptyOutput(IterableInterval<T> op) {
        RealType t = (RealType)op.iterator().next();
        return new Pair(t.createVariable(), t.createVariable());
    }

    @Override
    public Pair<T, T> compute(IterableInterval<T> op, Pair<T, T> r) {
        if (this.m_saturation == 0.0) {
            Iterator it = op.iterator();
            ((RealType)r.a).setReal(((RealType)r.a).getMaxValue());
            ((RealType)r.b).setReal(((RealType)r.b).getMinValue());
            while (it.hasNext()) {
                RealType i = (RealType)it.next();
                if (((RealType)r.a).compareTo(i) > 0) {
                    ((RealType)r.a).set(i);
                }
                if (((RealType)r.b).compareTo(i) >= 0) continue;
                ((RealType)r.b).set(i);
            }
        } else {
            this.calcMinMaxWithSaturation(op, r, this.m_histOp.compute(op, this.m_histOp.createEmptyOutput(op)));
        }
        return r;
    }

    private void calcMinMaxWithSaturation(IterableInterval<T> interval, Pair<T, T> r, OpsHistogram hist) {
        int i;
        int histMin = 0;
        int threshold = (int)((double)interval.size() * this.m_saturation / 200.0);
        int pCount = 0;
        for (i = 0; i < hist.numBins(); ++i) {
            if ((pCount += hist.get(i)) <= threshold) continue;
            histMin = i;
            break;
        }
        pCount = 0;
        int histMax = hist.numBins() - 1;
        for (i = hist.numBins() - 1; i >= 0; --i) {
            if ((pCount += hist.get(i)) <= threshold) continue;
            histMax = i;
            break;
        }
        ((RealType)r.a).setReal((double)histMin * ((((RealType)r.a).getMaxValue() - ((RealType)r.a).getMinValue()) / (double)hist.numBins()) + ((RealType)r.a).getMinValue());
        ((RealType)r.b).setReal((double)histMax * ((((RealType)r.a).getMaxValue() - ((RealType)r.a).getMinValue()) / (double)hist.numBins()) + ((RealType)r.a).getMinValue());
    }

    @Override
    public UnaryOutputOperation<IterableInterval<T>, Pair<T, T>> copy() {
        return new MinMax<T>();
    }

    @Override
    public Pair<T, T> compute(IterableInterval<T> in) {
        return this.compute(in, this.createEmptyOutput(in));
    }
}

