/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.iterableinterval.unary;

import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.type.Type;

public class Inset<T extends Type<T>, K extends RandomAccessibleInterval<T>>
implements UnaryOperation<IterableInterval<T>, K> {
    private final long[] m_offset;

    public Inset(long[] offset) {
        this.m_offset = offset;
    }

    @Override
    public K compute(IterableInterval<T> inset, K res) {
        long[] pos = new long[inset.numDimensions()];
        RandomAccess ra = res.randomAccess();
        for (int d = 0; d < Math.min(res.numDimensions(), this.m_offset.length); ++d) {
            ra.setPosition(this.m_offset[d], d);
        }
        Cursor<T> c = inset.localizingCursor();
        while (c.hasNext()) {
            c.fwd();
            c.localize(pos);
            for (int d = 0; d < pos.length; ++d) {
                ra.setPosition(this.m_offset[d] + pos[d], d);
            }
            ((Type)ra.get()).set((Type)c.get());
        }
        return res;
    }

    @Override
    public Inset<T, K> copy() {
        return new Inset<T, K>((long[])this.m_offset.clone());
    }
}

