/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.iterableinterval.unary;

import java.util.Random;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.ops.operation.iterableinterval.unary.MakeHistogram;
import net.imglib2.ops.operation.iterableinterval.unary.OpsHistogram;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;

public class EqualizeHistogram<T extends RealType<T>>
implements UnaryOperation<IterableInterval<T>, IterableInterval<T>> {
    private final int numBins;

    public EqualizeHistogram(int numBins) {
        this.numBins = numBins;
    }

    @Override
    public IterableInterval<T> compute(IterableInterval<T> in, IterableInterval<T> r) {
        assert (in.iterationOrder().equals(r.iterationOrder()));
        OpsHistogram histo = new MakeHistogram<T>(this.numBins).compute(in);
        RealType val = (RealType)((RealType)r.firstElement()).createVariable();
        int min = (int)val.getMaxValue();
        for (int i = 1; i < histo.numBins(); ++i) {
            histo.hist()[i] = histo.get(i) + histo.get(i - 1);
            if (histo.get(i) == 0) continue;
            min = Math.min(min, histo.get(i));
        }
        double gmax = histo.numBins();
        Cursor<T> cin = in.cursor();
        Cursor<T> cout = r.cursor();
        long numPix = r.size();
        while (cin.hasNext()) {
            cin.fwd();
            cout.fwd();
            val = (RealType)cin.get();
            int p = histo.getByValue(val.getRealFloat());
            double t = p - min;
            t /= (double)(numPix - (long)min);
            p = (int)Math.round(t *= gmax);
            ((RealType)cout.get()).setReal(histo.binToValue(p));
        }
        return r;
    }

    @Override
    public UnaryOperation<IterableInterval<T>, IterableInterval<T>> copy() {
        return new EqualizeHistogram<T>(this.numBins);
    }

    public static void main(String[] args) {
        Img<FloatType> test = new ArrayImgFactory<FloatType>().create(new int[]{10, 10}, new FloatType());
        Random rand = new Random();
        for (FloatType t : test) {
            t.setReal(rand.nextDouble() * 3.4028234663852886E38);
        }
        new EqualizeHistogram<FloatType>(256).compute((IterableInterval<FloatType>)test, (IterableInterval<FloatType>)test);
    }
}

