/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.iterable.binary.localthresholder;

import java.util.Iterator;
import net.imglib2.ops.operation.BinaryOperation;
import net.imglib2.ops.operation.iterable.unary.MedianOp;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;

public class MedianLocalThreshold<T extends RealType<T>, IN extends Iterator<T>>
implements BinaryOperation<IN, T, BitType> {
    private double m_c;
    private MedianOp<T, DoubleType> m_median;
    private DoubleType m_tmp;

    public MedianLocalThreshold(double c) {
        this.m_c = c;
        this.m_median = new MedianOp();
        this.m_tmp = new DoubleType();
    }

    @Override
    public BitType compute(IN input, T px, BitType output) {
        output.set(px.getRealDouble() > this.m_median.compute((Iterator<T>)input, this.m_tmp).getRealDouble() - this.m_c);
        return output;
    }

    @Override
    public BinaryOperation<IN, T, BitType> copy() {
        return new MedianLocalThreshold<T, IN>(this.m_c);
    }
}

