/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.iterable.binary.localthresholder;

import java.util.Iterator;
import net.imglib2.ops.operation.BinaryOperation;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;

public class MeanLocalThreshold<T extends RealType<T>, IN extends Iterator<T>>
implements BinaryOperation<IN, T, BitType> {
    private double m_c;

    public MeanLocalThreshold(double c) {
        this.m_c = c;
    }

    @Override
    public BitType compute(IN input, T px, BitType output) {
        int numElements = 0;
        double mean = 0.0;
        while (input.hasNext()) {
            mean += ((RealType)input.next()).getRealDouble();
            ++numElements;
        }
        output.set(px.getRealDouble() > (mean /= (double)numElements) - this.m_c);
        return output;
    }

    @Override
    public BinaryOperation<IN, T, BitType> copy() {
        return new MeanLocalThreshold<T, IN>(this.m_c);
    }
}

