/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.interval.unary;

import java.util.Arrays;
import java.util.Comparator;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.ops.operation.UnaryOutputOperation;

public final class MergeIntervals
implements UnaryOutputOperation<Interval[], Interval[]> {
    @Override
    public final Interval[] createEmptyOutput(Interval[] src) {
        return new Interval[src.length];
    }

    @Override
    public final Interval[] compute(Interval[] intervals, Interval[] res) {
        Arrays.sort(intervals, new Comparator<Interval>(){

            @Override
            public int compare(Interval o1, Interval o2) {
                for (int d = 0; d < Math.min(o1.numDimensions(), o2.numDimensions()); ++d) {
                    if (o1.min(d) == o2.min(d)) continue;
                    return (int)o1.min(d) - (int)o2.min(d);
                }
                return 0;
            }
        });
        long[] offset = new long[intervals[0].numDimensions()];
        long[] intervalWidth = new long[intervals[0].numDimensions()];
        intervals[0].min(offset);
        intervals[0].dimensions(intervalWidth);
        res[0] = this.shiftInterval(intervals[0], offset);
        for (int i = 1; i < intervals.length; ++i) {
            for (int d = 0; d < intervals[i].numDimensions(); ++d) {
                if (intervals[i].min(d) == intervals[i - 1].min(d)) continue;
                for (int innerD = d + 1; innerD < intervals[i].numDimensions(); ++innerD) {
                    intervalWidth[innerD] = 0L;
                }
                offset[d] = intervals[i].min(d) - intervalWidth[d];
                int n = d;
                intervalWidth[n] = intervalWidth[n] + intervals[i].dimension(d);
            }
            res[i] = this.shiftInterval(intervals[i], offset);
        }
        return res;
    }

    private Interval shiftInterval(Interval interval, long[] offset) {
        long[] min = new long[offset.length];
        long[] max = new long[offset.length];
        for (int d = 0; d < interval.numDimensions(); ++d) {
            min[d] = interval.min(d) - offset[d];
            max[d] = min[d] + interval.dimension(d) - 1L;
        }
        return new FinalInterval(min, max);
    }

    @Override
    public UnaryOutputOperation<Interval[], Interval[]> copy() {
        return new MergeIntervals();
    }

    @Override
    public Interval[] compute(Interval[] op) {
        return this.compute(op, this.createEmptyOutput(op));
    }
}

