/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.imgplus.unary;

import java.util.BitSet;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RealCursor;
import net.imglib2.img.Img;
import net.imglib2.img.ImgPlus;
import net.imglib2.ops.operation.UnaryOutputOperation;
import net.imglib2.ops.operation.metadata.unary.CopyCalibratedSpace;
import net.imglib2.ops.operation.metadata.unary.CopyImageMetadata;
import net.imglib2.ops.operation.metadata.unary.CopyMetadata;
import net.imglib2.ops.operation.metadata.unary.CopyNamed;
import net.imglib2.ops.operation.metadata.unary.CopySourced;
import net.imglib2.type.Type;

public class ImgPlusRemove1Dims<T extends Type<T>>
implements UnaryOutputOperation<ImgPlus<T>, ImgPlus<T>> {
    @Override
    public ImgPlus<T> createEmptyOutput(ImgPlus<T> op) {
        BitSet isLength1 = new BitSet(op.numDimensions());
        for (int d = 0; d < op.numDimensions(); ++d) {
            if (op.dimension(d) != 1L) continue;
            isLength1.set(d);
        }
        long[] min = new long[op.numDimensions() - isLength1.cardinality()];
        long[] max = new long[min.length];
        int d = 0;
        for (int i = 0; i < op.numDimensions(); ++i) {
            if (isLength1.get(i)) continue;
            max[d] = op.dimension(i) - 1L;
            ++d;
        }
        Img<T> res = op.factory().create(new FinalInterval(min, max), ((Type)op.firstElement()).createVariable());
        return new ImgPlus<T>(res);
    }

    @Override
    public ImgPlus<T> compute(ImgPlus<T> op, ImgPlus<T> r) {
        int d;
        RealCursor srcCur = op.localizingCursor();
        RandomAccess<T> resRA = r.randomAccess();
        new CopyMetadata(new CopyNamed(), new CopyImageMetadata(), new CopySourced(), new CopyCalibratedSpace(r)).compute(op, r);
        BitSet isLength1 = new BitSet(op.numDimensions());
        for (d = 0; d < op.numDimensions(); ++d) {
            if (op.dimension(d) != 1L) continue;
            isLength1.set(d);
        }
        while (srcCur.hasNext()) {
            srcCur.fwd();
            d = 0;
            for (int i = 0; i < op.numDimensions(); ++i) {
                if (isLength1.get(i)) continue;
                resRA.setPosition(srcCur.getLongPosition(i), d);
                ++d;
            }
            ((Type)resRA.get()).set((Type)srcCur.get());
        }
        return r;
    }

    @Override
    public UnaryOutputOperation<ImgPlus<T>, ImgPlus<T>> copy() {
        return new ImgPlusRemove1Dims<T>();
    }

    @Override
    public ImgPlus<T> compute(ImgPlus<T> op) {
        return this.compute(op, this.createEmptyOutput(op));
    }
}

