/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.imgplus.unary;

import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RealCursor;
import net.imglib2.RealInterval;
import net.imglib2.img.ImgPlus;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.type.Type;

public class ImgPlusCrop<T extends Type<T>>
implements UnaryOperation<ImgPlus<T>, ImgPlus<T>> {
    private final Interval m_interval;

    public ImgPlusCrop(long[] origin, long[] extend) {
        long[] max = new long[extend.length];
        for (int i = 0; i < max.length; ++i) {
            max[i] = origin[i] + extend[i] - 1L;
        }
        this.m_interval = new FinalInterval(origin, max);
    }

    public ImgPlusCrop(int[] origin, int[] extend) {
        long[] max = new long[extend.length];
        long[] loffset = new long[extend.length];
        for (int i = 0; i < max.length; ++i) {
            max[i] = origin[i] + extend[i] - 1;
            loffset[i] = origin[i];
        }
        this.m_interval = new FinalInterval(loffset, max);
    }

    public ImgPlusCrop(Interval interval) {
        this.m_interval = interval;
    }

    public ImgPlusCrop(RealInterval interval) {
        long[] min = new long[interval.numDimensions()];
        long[] max = new long[interval.numDimensions()];
        for (int i = 0; i < max.length; ++i) {
            min[i] = (long)Math.floor(interval.realMin(i));
            max[i] = (long)Math.ceil(interval.realMax(i));
        }
        this.m_interval = new FinalInterval(min, max);
    }

    @Override
    public ImgPlus<T> compute(ImgPlus<T> op, ImgPlus<T> r) {
        RealCursor rc = r.localizingCursor();
        RandomAccess<T> opc = op.randomAccess();
        while (rc.hasNext()) {
            rc.next();
            for (int d = 0; d < this.m_interval.numDimensions(); ++d) {
                opc.setPosition(rc.getLongPosition(d) + this.m_interval.min(d), d);
            }
            ((Type)rc.get()).set((Type)opc.get());
        }
        return r;
    }

    @Override
    public UnaryOperation<ImgPlus<T>, ImgPlus<T>> copy() {
        return new ImgPlusCrop<T>(this.m_interval);
    }
}

