/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.img.unary;

import java.util.Iterator;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.ops.operation.UnaryOutputOperation;
import net.imglib2.ops.operation.iterable.unary.Max;
import net.imglib2.ops.operation.iterable.unary.Mean;
import net.imglib2.ops.operation.iterable.unary.MedianOp;
import net.imglib2.ops.operation.iterable.unary.Min;
import net.imglib2.ops.operation.iterable.unary.StdDeviation;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;

public class ImgProject<T extends RealType<T>>
implements UnaryOutputOperation<Img<T>, Img<T>> {
    private final ProjectionType m_projectionType;
    private final int m_projectionDim;

    public ImgProject(ProjectionType type, int projectionDim) {
        this.m_projectionDim = projectionDim;
        this.m_projectionType = type;
    }

    @Override
    public Img<T> createEmptyOutput(Img<T> op) {
        long[] projectedImgDimSizes = new long[op.numDimensions() - 1];
        for (int d = 0; d < op.numDimensions(); ++d) {
            if (d < this.m_projectionDim) {
                projectedImgDimSizes[d] = op.dimension(d);
            }
            if (d <= this.m_projectionDim) continue;
            projectedImgDimSizes[d - 1] = op.dimension(d);
        }
        Img<T> projectedImage = op.factory().create(projectedImgDimSizes, ((RealType)op.randomAccess().get()).createVariable());
        return projectedImage;
    }

    @Override
    public Img<T> compute(final Img<T> op, Img<T> r) {
        Cursor projCur = r.localizingCursor();
        final RandomAccess srcRA = op.randomAccess();
        while (projCur.hasNext()) {
            projCur.fwd();
            for (int d = 0; d < op.numDimensions(); ++d) {
                if (d < this.m_projectionDim) {
                    srcRA.setPosition(projCur.getIntPosition(d), d);
                }
                if (d <= this.m_projectionDim) continue;
                srcRA.setPosition(projCur.getIntPosition(d - 1), d);
            }
            ((RealType)projCur.get()).setReal(this.handleProjection(new Iterator<T>(){
                int k = -1;

                @Override
                public boolean hasNext() {
                    return (long)this.k < op.dimension(ImgProject.this.m_projectionDim) - 1L;
                }

                @Override
                public T next() {
                    ++this.k;
                    srcRA.setPosition(this.k, ImgProject.this.m_projectionDim);
                    return (RealType)srcRA.get();
                }

                @Override
                public void remove() {
                }
            }));
        }
        return r;
    }

    private final double handleProjection(Iterator<T> iterable) {
        UnaryOperation op;
        switch (this.m_projectionType) {
            case AVG_INTENSITY: {
                op = new Mean();
                break;
            }
            case MEDIAN_INTENSITY: {
                op = new MedianOp();
                break;
            }
            case MAX_INTENSITY: {
                op = new Max();
                break;
            }
            case MIN_INTENSITY: {
                op = new Min();
                break;
            }
            case STD_DEVIATION: {
                op = new StdDeviation();
                break;
            }
            default: {
                throw new IllegalArgumentException("Projection Method doesn't exist");
            }
        }
        return op.compute(iterable, new DoubleType()).get();
    }

    @Override
    public UnaryOutputOperation<Img<T>, Img<T>> copy() {
        return new ImgProject<T>(this.m_projectionType, this.m_projectionDim);
    }

    @Override
    public Img<T> compute(Img<T> arg0) {
        return this.compute(arg0, this.createEmptyOutput(arg0));
    }

    public static enum ProjectionType {
        MAX_INTENSITY,
        MEDIAN_INTENSITY,
        AVG_INTENSITY,
        MIN_INTENSITY,
        STD_DEVIATION;

    }
}

