/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.img.unary;

import net.imglib2.IterableInterval;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.ops.img.UnaryOperationAssignment;
import net.imglib2.ops.operation.UnaryOutputOperation;
import net.imglib2.ops.operation.iterableinterval.unary.MinMax;
import net.imglib2.ops.operation.real.unary.Convert;
import net.imglib2.ops.operation.real.unary.Normalize;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Pair;
import net.imglib2.view.Views;

public class ImgConvert<I extends RealType<I>, O extends RealType<O> & NativeType<O>>
implements UnaryOutputOperation<Img<I>, Img<O>> {
    private final O m_outType;
    private final I m_inType;
    private final ImgConversionTypes m_conversionType;

    public ImgConvert(I inType, O outType, ImgConversionTypes type) {
        this.m_outType = outType;
        this.m_conversionType = type;
        this.m_inType = inType;
    }

    @Override
    public Img<O> compute(Img<I> img, Img<O> r) {
        Convert<I, O> convertOp = null;
        switch (this.m_conversionType) {
            case DIRECT: {
                convertOp = new Convert<I, O>(this.m_inType, this.m_outType, Convert.TypeConversionTypes.DIRECT);
                break;
            }
            case DIRECTCLIP: {
                convertOp = new Convert<I, O>(this.m_inType, this.m_outType, Convert.TypeConversionTypes.DIRECTCLIP);
                break;
            }
            case NORMALIZEDIRECT: {
                Pair<RealType, RealType> oldMinMax = new MinMax<RealType>(0.0, (RealType)img.firstElement()).compute((IterableInterval<RealType>)img);
                double factor = Normalize.normalizationFactor(((RealType)oldMinMax.a).getRealDouble(), ((RealType)oldMinMax.b).getRealDouble(), this.m_inType.getMinValue(), this.m_inType.getMaxValue());
                convertOp = new Convert<I, O>(this.m_inType, this.m_outType, Convert.TypeConversionTypes.SCALE);
                convertOp.setFactor(convertOp.getFactor() / factor);
                convertOp.setInMin(0.0);
                convertOp.setOutMin(0.0);
                break;
            }
            case NORMALIZESCALE: {
                Pair<RealType, RealType> oldMinMax = new MinMax<RealType>(0.0, (RealType)img.firstElement()).compute((IterableInterval<RealType>)img);
                double factor = Normalize.normalizationFactor(((RealType)oldMinMax.a).getRealDouble(), ((RealType)oldMinMax.b).getRealDouble(), this.m_inType.getMinValue(), this.m_inType.getMaxValue());
                convertOp = new Convert<I, O>(this.m_inType, this.m_outType, Convert.TypeConversionTypes.SCALE);
                convertOp.setFactor(convertOp.getFactor() / factor);
                convertOp.setInMin(((RealType)oldMinMax.a).getRealDouble());
                break;
            }
            case NORMALIZEDIRECTCLIP: {
                Pair<RealType, RealType> oldMinMax = new MinMax<RealType>(0.0, (RealType)img.firstElement()).compute((IterableInterval<RealType>)img);
                double factor = Normalize.normalizationFactor(((RealType)oldMinMax.a).getRealDouble(), ((RealType)oldMinMax.b).getRealDouble(), this.m_inType.getMinValue(), this.m_inType.getMaxValue());
                convertOp = new Convert<I, O>(this.m_inType, this.m_outType, Convert.TypeConversionTypes.SCALECLIP);
                convertOp.setFactor(convertOp.getFactor() / factor);
                convertOp.setInMin(((RealType)oldMinMax.a).getRealDouble());
                break;
            }
            case SCALE: {
                convertOp = new Convert<I, O>(this.m_inType, this.m_outType, Convert.TypeConversionTypes.SCALE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Normalization type unknown");
            }
        }
        UnaryOperationAssignment<I, O> map = new UnaryOperationAssignment<I, O>(convertOp);
        map.compute(Views.flatIterable(img), Views.flatIterable(r));
        return r;
    }

    @Override
    public UnaryOutputOperation<Img<I>, Img<O>> copy() {
        return new ImgConvert<RealType, RealType>((RealType)this.m_inType.copy(), (RealType)this.m_outType.copy(), this.m_conversionType);
    }

    @Override
    public Img<O> createEmptyOutput(Img<I> in) {
        try {
            return in.factory().imgFactory(this.m_outType).create(in, this.m_outType);
        }
        catch (IncompatibleTypeException e) {
            return new ArrayImgFactory<O>().create(in, this.m_outType);
        }
    }

    @Override
    public Img<O> compute(Img<I> in) {
        return this.compute(in, this.createEmptyOutput(in));
    }

    public static enum ImgConversionTypes {
        DIRECT("Copy"),
        DIRECTCLIP("Clip"),
        SCALE("Scale"),
        NORMALIZESCALE("Normalize and scale"),
        NORMALIZEDIRECT("Normalize"),
        NORMALIZEDIRECTCLIP("Normalize (clipped)");

        private final String m_label;

        public static String[] labelsAsStringArray() {
            ImgConversionTypes[] types = ImgConversionTypes.values();
            String[] res = new String[types.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = types[i].getLabel();
            }
            return res;
        }

        public static ImgConversionTypes getByLabel(String label) {
            for (ImgConversionTypes t : ImgConversionTypes.values()) {
                if (!t.getLabel().equals(label)) continue;
                return t;
            }
            return null;
        }

        private ImgConversionTypes(String label) {
            this.m_label = label;
        }

        public String getLabel() {
            return this.m_label;
        }
    }
}

