/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.img.binary;

import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.ops.operation.BinaryOperation;
import net.imglib2.type.numeric.RealType;

public class ImgCombine<U extends RealType<U>, V extends RealType<V>, W extends RealType<W>>
implements BinaryOperation<Img<U>, Img<V>, Img<W>> {
    private final BinaryOperation<U, V, W> operation;

    public ImgCombine(BinaryOperation<U, V, W> operation) {
        this.operation = operation;
    }

    @Override
    public Img<W> compute(Img<U> input1, Img<V> input2, Img<W> output) {
        long[] position = new long[output.numDimensions()];
        Cursor cursor = output.localizingCursor();
        RandomAccess accessor1 = input1.randomAccess();
        RandomAccess accessor2 = input2.randomAccess();
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.localize(position);
            accessor1.setPosition(position);
            accessor2.setPosition(position);
            this.operation.compute(accessor1.get(), accessor2.get(), cursor.get());
        }
        return output;
    }

    @Override
    public ImgCombine<U, V, W> copy() {
        return new ImgCombine<U, V, W>(this.operation.copy());
    }
}

