/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.complex.unary;

import net.imglib2.ops.operation.complex.unary.ComplexUnaryOperation;
import net.imglib2.ops.util.ComplexHelper;
import net.imglib2.type.numeric.ComplexType;

public final class ComplexRoot<I extends ComplexType<I>, O extends ComplexType<O>>
implements ComplexUnaryOperation<I, O> {
    private final int power;

    public ComplexRoot(int power) {
        if (power < 1) {
            throw new IllegalArgumentException("ComplexRoot requires a positive number of roots");
        }
        this.power = power;
    }

    @Override
    public O compute(I z, O output) {
        double modulus = ComplexHelper.getModulus(z);
        double argument = ComplexHelper.getArgument(z);
        double princpArg = ComplexHelper.getPrincipleArgument(argument);
        double r = Math.pow(modulus, 1.0 / (double)this.power);
        double theta = princpArg / (double)this.power;
        ComplexHelper.setPolar(output, r, theta);
        return output;
    }

    @Override
    public ComplexRoot<I, O> copy() {
        return new ComplexRoot<I, O>(this.power);
    }
}

