/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.complex.unary;

import net.imglib2.ops.operation.complex.unary.ComplexUnaryOperation;
import net.imglib2.type.numeric.ComplexType;

public final class ComplexReciprocal<I extends ComplexType<I>, O extends ComplexType<O>>
implements ComplexUnaryOperation<I, O> {
    @Override
    public O compute(I z, O output) {
        double denom = z.getRealDouble() * z.getRealDouble() + z.getImaginaryDouble() * z.getImaginaryDouble();
        double x = z.getRealDouble() / denom;
        double y = -z.getImaginaryDouble() / denom;
        output.setComplexNumber(x, y);
        return output;
    }

    @Override
    public ComplexReciprocal<I, O> copy() {
        return new ComplexReciprocal<I, O>();
    }
}

