/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.operation.complex.unary;

import net.imglib2.ops.operation.complex.unary.ComplexUnaryOperation;
import net.imglib2.ops.util.ComplexHelper;
import net.imglib2.type.numeric.ComplexType;

public final class ComplexIntegerPower<I extends ComplexType<I>, O extends ComplexType<O>>
implements ComplexUnaryOperation<I, O> {
    private final int power;

    public ComplexIntegerPower(int power) {
        this.power = power;
    }

    @Override
    public O compute(I z, O output) {
        double modulus = ComplexHelper.getModulus(z);
        double argument = ComplexHelper.getArgument(z);
        double r = Math.pow(modulus, this.power);
        double theta = ComplexHelper.getPrincipleArgument((double)this.power * argument);
        ComplexHelper.setPolar(output, r, theta);
        return output;
    }

    @Override
    public ComplexIntegerPower<I, O> copy() {
        return new ComplexIntegerPower<I, O>(this.power);
    }
}

