/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.img;

import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.type.Type;

public class UnaryOperationAssignment<T extends Type<T>, V extends Type<V>>
implements UnaryOperation<IterableInterval<T>, IterableInterval<V>> {
    private final UnaryOperation<T, V> m_op;

    public UnaryOperationAssignment(UnaryOperation<T, V> op) {
        this.m_op = op;
    }

    @Override
    public IterableInterval<V> compute(IterableInterval<T> input, IterableInterval<V> output) {
        if (!input.iterationOrder().equals(output.iterationOrder())) {
            throw new IllegalArgumentException("Intervals in UnaryOperationAssignment are not compatible: different dimensions.");
        }
        Cursor<T> inCursor = input.cursor();
        Cursor<V> outCursor = output.cursor();
        while (inCursor.hasNext()) {
            inCursor.fwd();
            outCursor.fwd();
            this.m_op.compute(inCursor.get(), outCursor.get());
        }
        return output;
    }

    @Override
    public UnaryOperation<IterableInterval<T>, IterableInterval<V>> copy() {
        return new UnaryOperationAssignment<T, V>(this.m_op.copy());
    }
}

