/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.img;

import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.ops.operation.BinaryOperation;
import net.imglib2.type.numeric.RealType;

public class UnaryConstantRightAssignment<T extends RealType<T>, V extends RealType<V>, O extends RealType<O>>
implements BinaryOperation<IterableInterval<T>, V, IterableInterval<O>> {
    private BinaryOperation<T, V, O> m_op;

    public UnaryConstantRightAssignment(BinaryOperation<T, V, O> op) {
        this.m_op = op;
    }

    @Override
    public IterableInterval<O> compute(IterableInterval<T> input, V constant, IterableInterval<O> output) {
        if (!input.iterationOrder().equals(output.iterationOrder())) {
            throw new IllegalArgumentException("Intervals are not compatible");
        }
        Cursor<T> inCursor = input.cursor();
        Cursor<O> outCursor = output.cursor();
        while (inCursor.hasNext() && outCursor.hasNext()) {
            inCursor.fwd();
            outCursor.fwd();
            this.m_op.compute(inCursor.get(), constant, outCursor.get());
        }
        return output;
    }

    @Override
    public BinaryOperation<IterableInterval<T>, V, IterableInterval<O>> copy() {
        return new UnaryConstantRightAssignment<T, V, O>(this.m_op);
    }
}

