/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.img;

import java.util.Random;
import net.imglib2.Cursor;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.ops.function.general.GeneralBinaryFunction;
import net.imglib2.ops.function.general.GeneralUnaryFunction;
import net.imglib2.ops.function.real.RealImageFunction;
import net.imglib2.ops.img.ImageAssignment;
import net.imglib2.ops.input.PointInputIteratorFactory;
import net.imglib2.ops.operation.BinaryOperation;
import net.imglib2.ops.operation.UnaryOperation;
import net.imglib2.ops.operation.real.binary.RealAdd;
import net.imglib2.ops.operation.real.binary.RealXor;
import net.imglib2.ops.operation.real.unary.RealMaxConstant;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;

public class ImageCombiner {
    public static <I1 extends RealType<I1>, I2 extends RealType<I2>, O extends RealType<O>> Img<O> applyOp(BinaryOperation<I1, I2, O> op, Img<I1> input1, Img<I2> input2, ImgFactory<O> imgFactory, O type) {
        long[] span = ImageCombiner.determineSharedExtents(input1, input2);
        Img<O> output = imgFactory.create(span, type);
        ImageCombiner.binaryAssign(op, input1, input2, output, span);
        return output;
    }

    public static <I1 extends RealType<I1>, I2 extends RealType<I2>, O extends RealType<O>> void applyOp(BinaryOperation<I1, I2, O> op, Img<I1> input1, Img<I2> input2, Img<O> output) {
        long[] span = ImageCombiner.determineSharedExtents(input1, input2, output);
        ImageCombiner.binaryAssign(op, input1, input2, output, span);
    }

    public static <I extends RealType<I>, O extends RealType<O>> Img<O> applyOp(UnaryOperation<I, O> op, Img<I> input, ImgFactory<O> imgFactory, O type) {
        long[] span = new long[input.numDimensions()];
        input.dimensions(span);
        Img<O> output = imgFactory.create(span, type);
        ImageCombiner.unaryAssign(op, input, output, span);
        return output;
    }

    public static <I extends RealType<I>, O extends RealType<O>> void applyOp(UnaryOperation<I, O> op, Img<I> input, Img<O> output) {
        long[] span = ImageCombiner.determineSharedExtents(input, output);
        ImageCombiner.unaryAssign(op, input, output, span);
    }

    private static long[] determineSharedExtents(Img<?> ... imgs) {
        if (imgs.length == 0) {
            throw new IllegalArgumentException("at least one image must be provided");
        }
        int numDims = imgs[0].numDimensions();
        long[] commonRegion = new long[numDims];
        imgs[0].dimensions(commonRegion);
        for (int i = 1; i < imgs.length; ++i) {
            if (imgs[i].numDimensions() != numDims) {
                throw new IllegalArgumentException("images do not have compatible dimensions");
            }
            for (int d = 0; d < numDims; ++d) {
                commonRegion[d] = Math.min(imgs[i].dimension(d), commonRegion[d]);
            }
        }
        return commonRegion;
    }

    private static <I1 extends RealType<I1>, I2 extends RealType<I2>, O extends RealType<O>> void binaryAssign(BinaryOperation<I1, I2, O> op, Img<I1> input1, Img<I2> input2, Img<O> output, long[] span) {
        long[] origin = new long[span.length];
        RealType type = (RealType)output.firstElement();
        RealImageFunction<I1, RealType> f1 = new RealImageFunction<I1, RealType>(input1, (RealType)input1.firstElement());
        RealImageFunction<I2, RealType> f2 = new RealImageFunction<I2, RealType>(input2, (RealType)input2.firstElement());
        GeneralBinaryFunction<I1, RealType, RealType, ComplexType> binFunc = new GeneralBinaryFunction<I1, RealType, RealType, ComplexType>(f1, f2, op, (ComplexType)type.copy());
        PointInputIteratorFactory inputFactory = new PointInputIteratorFactory();
        ImageAssignment assigner = new ImageAssignment(output, origin, span, binFunc, null, inputFactory);
        assigner.assign();
    }

    private static <I extends RealType<I>, O extends RealType<O>> void unaryAssign(UnaryOperation<I, O> op, Img<I> input, Img<O> output, long[] span) {
        RealType type = (RealType)output.firstElement();
        RealImageFunction<I, RealType> f1 = new RealImageFunction<I, RealType>(input, (RealType)input.firstElement());
        GeneralUnaryFunction<I, RealType, ComplexType> unaryFunc = new GeneralUnaryFunction<I, RealType, ComplexType>(f1, op, (ComplexType)type.copy());
        PointInputIteratorFactory inputFactory = new PointInputIteratorFactory();
        ImageAssignment assigner = new ImageAssignment(output, new long[span.length], span, unaryFunc, null, inputFactory);
        assigner.assign();
    }

    public static void main(String[] args) {
        ImageCombiner.maxCreateExample();
        ImageCombiner.maxFillExample();
        ImageCombiner.addCreateExample();
        ImageCombiner.addFillExample();
        ImageCombiner.xorCreateExample();
        ImageCombiner.xorFillExample();
    }

    private static void addCreateExample() {
        Img<UnsignedByteType> img1 = ImageCombiner.makeTestImage(new long[]{100L, 200L}, new UnsignedByteType());
        Img<FloatType> img2 = ImageCombiner.makeTestImage(new long[]{75L, 225L}, new FloatType());
        ArrayImgFactory imgFactory = new ArrayImgFactory();
        RealAdd addOp = new RealAdd();
        Img<ShortType> output = ImageCombiner.applyOp(addOp, img1, img2, imgFactory, new ShortType());
        System.out.println("--- add create test ---");
        System.out.println("Input image one is " + img1.dimension(0) + " x " + img1.dimension(1));
        System.out.println("Input image two is " + img2.dimension(0) + " x " + img2.dimension(1));
        System.out.println("Output image is " + output.dimension(0) + " x " + output.dimension(1));
        System.out.println();
    }

    private static void addFillExample() {
        Img<UnsignedByteType> img1 = ImageCombiner.makeTestImage(new long[]{100L, 200L}, new UnsignedByteType());
        Img<FloatType> img2 = ImageCombiner.makeTestImage(new long[]{75L, 225L}, new FloatType());
        Img<ShortType> output = ImageCombiner.makeTestImage(new long[]{75L, 225L}, new ShortType());
        RealAdd addOp = new RealAdd();
        ImageCombiner.applyOp(addOp, img1, img2, output);
        System.out.println("--- add fill test ---");
        System.out.println("Input image one is " + img1.dimension(0) + " x " + img1.dimension(1));
        System.out.println("Input image two is " + img2.dimension(0) + " x " + img2.dimension(1));
        System.out.println("Output image is " + output.dimension(0) + " x " + output.dimension(1));
        System.out.println();
    }

    private static void maxCreateExample() {
        Img<DoubleType> img = ImageCombiner.makeTestImage(new long[]{512L, 512L}, new DoubleType());
        ArrayImgFactory imgFactory = new ArrayImgFactory();
        RealMaxConstant maxOp = new RealMaxConstant(150.0);
        Img<IntType> output = ImageCombiner.applyOp(maxOp, img, imgFactory, new IntType());
        System.out.println("--- max create test ---");
        System.out.println("Input image is " + img.dimension(0) + " x " + img.dimension(1));
        System.out.println("Output image is " + output.dimension(0) + " x " + output.dimension(1));
        System.out.println();
    }

    private static void maxFillExample() {
        Img<DoubleType> img = ImageCombiner.makeTestImage(new long[]{512L, 512L}, new DoubleType());
        Img<IntType> output = ImageCombiner.makeTestImage(new long[]{512L, 512L}, new IntType());
        RealMaxConstant maxOp = new RealMaxConstant(150.0);
        ImageCombiner.applyOp(maxOp, img, output);
        System.out.println("--- max fill test ---");
        System.out.println("Input image is " + img.dimension(0) + " x " + img.dimension(1));
        System.out.println("Output image is " + output.dimension(0) + " x " + output.dimension(1));
        System.out.println();
    }

    private static void xorCreateExample() {
        Img<UnsignedByteType> img1 = ImageCombiner.makeTestImage(new long[]{400L, 300L}, new UnsignedByteType());
        Img<UnsignedByteType> img2 = ImageCombiner.makeTestImage(new long[]{300L, 400L}, new UnsignedByteType());
        ArrayImgFactory imgFactory = new ArrayImgFactory();
        RealXor xorOp = new RealXor();
        Img<IntType> output = ImageCombiner.applyOp(xorOp, img1, img2, imgFactory, new IntType());
        System.out.println("--- xor create test ---");
        System.out.println("Input image one is " + img1.dimension(0) + " x " + img1.dimension(1));
        System.out.println("Input image two is " + img2.dimension(0) + " x " + img2.dimension(1));
        System.out.println("Output image is " + output.dimension(0) + " x " + output.dimension(1));
        System.out.println();
    }

    private static void xorFillExample() {
        Img<UnsignedByteType> img1 = ImageCombiner.makeTestImage(new long[]{400L, 300L}, new UnsignedByteType());
        Img<UnsignedByteType> img2 = ImageCombiner.makeTestImage(new long[]{300L, 400L}, new UnsignedByteType());
        Img<IntType> output = ImageCombiner.makeTestImage(new long[]{300L, 400L}, new IntType());
        RealXor xorOp = new RealXor();
        ImageCombiner.applyOp(xorOp, img1, img2, output);
        System.out.println("--- xor fill test ---");
        System.out.println("Input image one is " + img1.dimension(0) + " x " + img1.dimension(1));
        System.out.println("Input image two is " + img2.dimension(0) + " x " + img2.dimension(1));
        System.out.println("Output image is " + output.dimension(0) + " x " + output.dimension(1));
        System.out.println();
    }

    private static <O extends RealType<O> & NativeType<O>> Img<O> makeTestImage(long[] dims, O type) {
        ArrayImgFactory<O> imgFactory = new ArrayImgFactory<O>();
        Img<O> image = ((ImgFactory)imgFactory).create(dims, type);
        ImageCombiner.fillImage(image);
        return image;
    }

    private static <O extends RealType<O>> void fillImage(Img<O> img) {
        Random rng = new Random();
        Cursor cursor = img.cursor();
        while (cursor.hasNext()) {
            double value = 256.0 * rng.nextDouble();
            ((RealType)cursor.next()).setReal(value);
        }
    }
}

