/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.img;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.ops.condition.Condition;
import net.imglib2.ops.function.Function;
import net.imglib2.ops.input.InputIterator;
import net.imglib2.ops.input.InputIteratorFactory;
import net.imglib2.ops.pointset.HyperVolumePointSet;
import net.imglib2.type.numeric.ComplexType;

public class ImageAssignment<OUTPUT extends ComplexType<OUTPUT>, INTERMEDIATE extends ComplexType<INTERMEDIATE>, INPUT> {
    private ExecutorService executor = null;
    private boolean assigning = false;
    private List<Runnable> tasks = null;

    public ImageAssignment(Img<OUTPUT> img, long[] origin, long[] span, Function<INPUT, INTERMEDIATE> function, Condition<INPUT> condition, InputIteratorFactory<INPUT> factory) {
        this.setupTasks(img, origin, span, function, condition, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign() {
        ImageAssignment imageAssignment;
        ImageAssignment imageAssignment2 = this;
        synchronized (imageAssignment2) {
            this.assigning = true;
            this.executor = Executors.newFixedThreadPool(this.tasks.size());
            for (Runnable task : this.tasks) {
                this.executor.submit(task);
            }
        }
        boolean terminated = true;
        ImageAssignment i$ = this;
        synchronized (i$) {
            this.executor.shutdown();
            terminated = this.executor.isTerminated();
            if (terminated) {
                this.executor = null;
            }
        }
        while (!terminated) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            imageAssignment = this;
            synchronized (imageAssignment) {
                terminated = this.executor.isTerminated();
                if (terminated) {
                    this.executor = null;
                }
            }
        }
        imageAssignment = this;
        synchronized (imageAssignment) {
            this.assigning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        boolean terminated = true;
        ImageAssignment imageAssignment = this;
        synchronized (imageAssignment) {
            if (!this.assigning) {
                return;
            }
            if (this.executor != null) {
                this.executor.shutdownNow();
                terminated = this.executor.isTerminated();
            }
        }
        while (!terminated) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            imageAssignment = this;
            synchronized (imageAssignment) {
                terminated = this.executor == null ? true : this.executor.isTerminated();
            }
        }
    }

    private void setupTasks(Img<OUTPUT> img, long[] origin, long[] span, Function<INPUT, INTERMEDIATE> func, Condition<INPUT> cond, InputIteratorFactory<INPUT> factory) {
        this.tasks = new ArrayList<Runnable>();
        int axis = this.chooseBestAxis(span);
        int numThreads = this.chooseNumThreads(span, axis);
        long length = span[axis] / (long)numThreads;
        if (span[axis] % (long)numThreads > 0L) {
            ++length;
        }
        for (long startOffset = 0L; startOffset < span[axis]; startOffset += length) {
            if (startOffset + length > span[axis]) {
                length = span[axis] - startOffset;
            }
            Runnable task = this.task(img, origin, span, axis, origin[axis] + startOffset, length, func, cond, factory);
            this.tasks.add(task);
        }
    }

    private int chooseBestAxis(long[] span) {
        int bestAxis = 0;
        long bestAxisSize = span[bestAxis];
        for (int i = 1; i < span.length; ++i) {
            long axisSize = span[i];
            if (axisSize <= bestAxisSize) continue;
            bestAxis = i;
            bestAxisSize = axisSize;
        }
        return bestAxis;
    }

    private int chooseNumThreads(long[] span, int axis) {
        int maxThreads = Runtime.getRuntime().availableProcessors();
        if (maxThreads == 1) {
            return 1;
        }
        long numElements = this.numElements(span);
        if (numElements < 10000L) {
            return 1;
        }
        long axisSize = span[axis];
        if (axisSize < (long)maxThreads) {
            return (int)axisSize;
        }
        return maxThreads;
    }

    private long numElements(long[] span) {
        if (span.length == 0) {
            return 0L;
        }
        long numElems = span[0];
        for (int i = 1; i < span.length; ++i) {
            numElems *= span[i];
        }
        return numElems;
    }

    private Runnable task(Img<OUTPUT> img, long[] imageOrigin, long[] imageSpan, int axis, long startIndex, long length, Function<INPUT, INTERMEDIATE> fn, Condition<INPUT> cnd, InputIteratorFactory<INPUT> factory) {
        long[] regOrigin = (long[])imageOrigin.clone();
        regOrigin[axis] = startIndex;
        long[] regSpan = (long[])imageSpan.clone();
        regSpan[axis] = length;
        long[] regMin = regOrigin;
        long[] regMax = new long[regMin.length];
        for (int i = 0; i < regMin.length; ++i) {
            regMax[i] = regMin[i] + regSpan[i] - 1L;
        }
        HyperVolumePointSet region = new HyperVolumePointSet(regMin, regMax);
        return new RegionRunner<OUTPUT, INTERMEDIATE>(img, factory.createInputIterator(region), fn.copy(), cnd == null ? null : cnd.copy());
    }

    private class RegionRunner<U extends ComplexType<U>, V extends ComplexType<V>>
    implements Runnable {
        private final Img<U> img;
        private final Function<INPUT, V> function;
        private final Condition<INPUT> condition;
        private final InputIterator<INPUT> iter;

        public RegionRunner(Img<U> img, InputIterator<INPUT> iter, Function<INPUT, V> func, Condition<INPUT> cond) {
            this.img = img;
            this.function = func;
            this.condition = cond;
            this.iter = iter;
        }

        @Override
        public void run() {
            RandomAccess accessor = this.img.randomAccess();
            ComplexType output = (ComplexType)this.function.createOutput();
            Object input = null;
            while (this.iter.hasNext()) {
                input = this.iter.next(input);
                boolean proceed = this.condition == null || this.condition.isTrue(input);
                if (!proceed) continue;
                this.function.compute(input, output);
                accessor.setPosition(this.iter.getCurrentPoint());
                ((ComplexType)accessor.get()).setReal(output.getRealDouble());
                ((ComplexType)accessor.get()).setImaginary(output.getImaginaryDouble());
            }
        }
    }
}

