/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.function.real;

import net.imglib2.ExtendedRandomAccessibleInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.ops.function.Function;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.numeric.RealType;

public class RealImageFunction<I extends RealType<I>, O extends RealType<O>>
implements Function<long[], O> {
    private final RandomAccess<I> accessor;
    private final O type;

    private RealImageFunction(RandomAccess<I> acc, O type) {
        this.accessor = acc;
        this.type = type;
    }

    public RealImageFunction(RandomAccessibleInterval<I> img, O type) {
        this.accessor = img.randomAccess();
        this.type = type;
    }

    public RealImageFunction(RandomAccessibleInterval<I> img, OutOfBoundsFactory<I, RandomAccessibleInterval<I>> factory, O type) {
        ExtendedRandomAccessibleInterval<I, RandomAccessibleInterval<I>> extendedRandAcessible = new ExtendedRandomAccessibleInterval<I, RandomAccessibleInterval<I>>(img, factory);
        this.accessor = extendedRandAcessible.randomAccess();
        this.type = type;
    }

    @Override
    public void compute(long[] point, O output) {
        this.accessor.setPosition(point);
        double r = ((RealType)this.accessor.get()).getRealDouble();
        output.setReal(r);
    }

    @Override
    public RealImageFunction<I, O> copy() {
        return new RealImageFunction<I, RealType>(this.accessor.copyRandomAccess(), (RealType)this.type.copy());
    }

    @Override
    public O createOutput() {
        return (O)((RealType)this.type.createVariable());
    }
}

