/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.function.real;

import net.imglib2.img.Img;
import net.imglib2.ops.function.Function;
import net.imglib2.ops.parse.RealEquationFunctionParser;
import net.imglib2.ops.util.Tuple2;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;

public class RealEquationFunction<T extends RealType<T>>
implements Function<long[], T> {
    private final String origSpec;
    private final Function<long[], DoubleType> eqnFunc;
    private final DoubleType tmp;
    private final T factory;
    private final Img<T> img;

    public RealEquationFunction(String specification, T type, Img<T> img) {
        RealEquationFunctionParser parser = new RealEquationFunctionParser();
        Tuple2<Function<long[], DoubleType>, String> result = parser.parse(specification, img);
        if (result.get2() != null) {
            throw new IllegalArgumentException(result.get2());
        }
        this.eqnFunc = result.get1();
        this.origSpec = specification;
        this.tmp = new DoubleType();
        this.factory = type;
        this.img = img;
    }

    public RealEquationFunction(String specification, T type) {
        this(specification, type, null);
    }

    @Override
    public void compute(long[] input, T output) {
        this.eqnFunc.compute(input, this.tmp);
        output.setReal(this.tmp.getRealDouble());
    }

    @Override
    public T createOutput() {
        return (T)((RealType)this.factory.createVariable());
    }

    public RealEquationFunction<T> copy() {
        return new RealEquationFunction<Object>(this.origSpec, this.createOutput(), this.img);
    }
}

